<?php

namespace Database\Seeders;

use App\Models\Page;
use App\Enums\Status;
use Illuminate\Database\Seeder;
use Dipokhalder\EnvEditor\EnvEditor;

class PageTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $envService = new EnvEditor();
        if ($envService->getValue('DEMO')) {
            Page::insert([
                [
                    'title'            => 'FAQ',
                    'slug'             => 'faq',
                    'description'      => '<h3>How do I check my order status?</h3><p>To check the status of your order, including processing and delivery updates, you can log in to your My Account or enter your order number and email address. Once your order has been dispatched, you will receive an email with a tracking number for all delivery updates.</p><p><br></p><h3>Can I change or cancel my order once it has been placed?</h3><p>Unfortunately, no. Once your order has been placed, it is sent to our warehouse for processing immediately to ensure quick delivery. If you need to return an item, please refer to our Return &amp; Exchange policy.</p><p><br></p><h3>How do I return or exchange an item?</h3><p>We are happy to offer returns for orders placed on StoreKing within 30 days of purchase. You may return your products in their original, unused condition for a full refund. To start your return, please contact our customer service team at [Contact Information].</p><p>At this time, we do not offer direct exchanges. To exchange an item, you must return the original item and place a new order.</p><p><br></p><h3>What types of payments are accepted?</h3><p>We accept payment by debit/credit cards, Apple Pay, Google Pay, PayPal, and StoreKing Gift Cards. Visit our Payment Options page for more information.</p><p><br></p><h3>How do I use a promotion/coupon code?</h3><p>To use your promotion or coupon code, enter the code at checkout in the appropriate field. Make sure you enter the code with the exact spelling and capitalization as shown. Click "apply" for the discount to be applied. The discounted amount will be displayed on the Shopping Bag and Order Summary pages. If the code is invalid, expired, or you have not placed the correct products in the shopping bag, the discount will not be applied.</p><p><br></p><h3>Why is my coupon code not working?</h3><p>Our offer codes may exclude certain items such as new product releases, promotional items, clearance merchandise, and specific categories. Offers cannot be combined with any other shipping promotion, offer, or coupon. They cannot be applied to past purchases, redeemed for cash, used to purchase gift cards, or used as payment on an account.</p><p><br></p><h3>How quickly will my order be delivered?</h3><p>At StoreKing, we pride ourselves on our quick delivery service. We deliver groceries within 1 hour of placing your order. Please ensure your delivery address is within our service area.</p><p><br></p><h3>What if my order is late?</h3><p>If your order is late, please contact our customer service team at [Contact Information] for assistance. We strive to ensure timely delivery, but unforeseen circumstances can sometimes cause delays.</p><p><br></p><h3>Can I schedule a delivery for a specific time?</h3><p>Currently, we offer express delivery within 1 hour. We do not offer specific time slots for delivery, but we are working on enhancing our delivery options to better serve our customers.</p><p><br></p><h3>What items are not eligible for return?</h3><p>We do not accept returns on perishable items, including fresh produce, dairy, and frozen goods. Returns are also not accepted on items that have been opened or used, unless they are defective or damaged.</p>',
                    'menu_section_id'  => 1,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Return & Exchange',
                    'slug'             => 'return-and-exchange',
                    'description'      => "<p>At StoreKing, we want you to be completely satisfied with your purchase. If you're not happy with your order for any reason, we're here to help. Please review our return and exchange policy below:</p><p><br></p><h3>Free Returns</h3><p>We offer hassle-free returns for all eligible orders. If you're not satisfied with your purchase, you can return it within 30 days of delivery for a full refund or exchange.</p><p><br></p><h3>Initiate Your Return</h3><p>To initiate a return, please contact our customer service team at [Contact Information]. We will provide you with instructions on how to return your items.</p><p><br></p><h3>Refunds</h3><ul><li><strong>Payment Method:</strong> Refunds will be credited back to the original form of payment used for the purchase.</li><li><strong>Processing Time:</strong> Returns may take up to 5 business days to process once received. Please allow additional time for your financial institution to process the refund.</li></ul><p><br></p><h3>Return Exceptions</h3><ul><li>We do not accept returns on perishable items, including fresh produce, dairy, and frozen goods.</li><li>Returns are not accepted on items that have been opened or used, unless they are defective or damaged.</li></ul><p><br></p><h3>In-Store Returns</h3><p>You may also return items purchased online to any StoreKing store. Please bring the original receipt or order confirmation email with you for faster processing.</p><p><br></p><h3>Exchanges</h3><p>At this time, we do not offer direct exchanges. If you wish to exchange an item, please return it following our return process and place a new order for the desired item.</p><p><br></p><h3>Contact Us</h3><p>If you have any questions or concerns about our return and exchange policy, please contact our customer service team at [Contact Information]. We're here to assist you every step of the way.</p><p>Thank you for shopping at StoreKing. We appreciate your business!</p>",
                    'menu_section_id'  => 1,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Delivery',
                    'slug'             => 'delivery',
                    'description'      => '<p>At StoreKing, we strive to deliver your groceries quickly and efficiently. Our goal is to make your shopping experience as convenient as possible by offering speedy delivery services. Here is everything you need to know about our delivery options:</p><p><br></p><h3>Delivery Options</h3><p><br></p><p><strong>Express Delivery (Within 1 Hour)</strong></p><ul><li><strong>Cost:</strong> £4.50 for orders below £50, free for orders over £50.</li><li><strong>Availability:</strong> Available for most locations within the delivery radius. Please ensure your delivery address is within our service area.</li></ul><h3>Additional Information</h3><ul><li><strong>Order Cut-off Time:</strong> Orders placed after 9:00 PM will be delivered the next day.</li><li><strong>Delivery Tracking:</strong> You will receive a tracking link via email or SMS once your order is out for delivery.</li><li><strong>Delivery Zones:</strong> While we aim to reach as many customers as possible, some remote locations may not be covered. During checkout, you will be notified if your delivery address is outside our service area.</li><li><br></li></ul><h3>Store Pick-up</h3><p><strong>Free for all eligible orders.</strong></p><p>Just tap or click "PICK UP" during checkout to see if the items in your cart are eligible for pick-up at an StoreKing store near you.</p><p><br></p><h3>Important Notes</h3><ul><li><strong>Gift Cards:</strong> Gift cards are sent via standard delivery and may take up to 5 business days to arrive.</li><li><strong>Remote Locations:</strong> Delivery to certain remote locations may take longer than the standard delivery time.</li><li><strong>Ineligible Delivery Areas:</strong> We do not deliver to the following postcodes: Falkland Islands (FIQQ 1ZZ), Channel Islands (GY1–GY9, JE1–JE4), and Gibraltar (GX11 1AA).</li></ul><p><br></p><p>We are committed to providing you with the best possible service. If you have any questions or concerns about your delivery, please contact our customer service team at [Contact Information].</p><p>Thank you for choosing StoreKing for your grocery needs!</p>',
                    'menu_section_id'  => 1,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Contact Us',
                    'slug'             => 'contact-us',
                    'description'      => "<p>Questions, Concerns, Comments? You talk, we listen.</p><p>If you have any additional questions or comments, we would love to hear from you!</p><p>Submit your query using any of the methods below.</p><p><br></p><p>Email: info@inilabs.net</p><p>Toll-free number: +88013333846282, 7 days a week</p>",
                    'menu_section_id'  => 1,
                    'menu_template_id' => 1,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],

                [
                    'title'            => 'About Us',
                    'slug'             => 'about-us',
                    'description'      => "<p>Welcome to StoreKing, your one-stop shop for all your grocery needs. We understand that groceries are more than just products—they are the foundation of a happy and healthy home. That’s why we are committed to providing you with the highest quality products and the best shopping experience possible.</p><p><br></p><h3>Our Purpose</h3><p>Our purpose is simple: To make your life easier and healthier. We believe that access to fresh, high-quality groceries should be convenient and affordable for everyone. By providing a wide range of products and exceptional service, we aim to be a reliable partner in your daily life.</p><p><br></p><h3>Our Mission</h3><p>Our mission is to be the most trusted grocery store in the community. Every day, we strive to offer the freshest produce, the finest meats, and a diverse selection of pantry staples and specialty items. We are dedicated to ensuring that every product on our shelves meets our high standards of quality and sustainability.</p><p><br></p><h3>Our Commitment</h3><p>At StoreKing, we are committed to supporting local farmers and producers. We believe in the importance of knowing where your food comes from and the impact it has on the environment. That’s why we prioritize sourcing locally and sustainably, ensuring that you get the best products while supporting our community and protecting our planet.</p><p><br></p><h3>Our Service</h3><p>We know that your time is valuable, and we are here to make your shopping experience as smooth and enjoyable as possible. Whether you’re shopping online or visiting our store, our friendly and knowledgeable staff are always ready to assist you. We offer convenient delivery and pick-up options to fit your busy schedule.</p><p><br></p><h3>Our Vision</h3><p>Our vision is to be more than just a grocery store. We want to be a place where you feel valued and cared for, a place where you can find not only the products you need but also the inspiration for a healthier and happier lifestyle. Together, we can build a community that thrives on good food, good health, and good values.</p><p><br></p><p>Thank you for choosing StoreKing. We look forward to serving you!</p>",
                    'menu_section_id'  => 2,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],

                [
                    'title'            => 'Cookies Policy',
                    'slug'             => 'cookies-policy',
                    'description'      => '<p>This Cookies Policy explains how StoreKing ("us", "we", or "our") collects, uses, stores, shares, and uses cookies on its website. We provide information on how cookies and similar technologies work, their purpose, use, and duration, how we process and store them, and how you can control them. You can also find all the necessary information regarding your rights on the use of cookies on this website and how you can exercise them.</p><p><br></p><h3>COOKIES AND SIMILAR TECHNOLOGIES</h3><p>Cookies are small data files that are stored on a user’s device by the browser when visiting a website or application. Cookies are used for various reasons and can be very useful in many cases. They can be necessary for the proper functionality of the website and efficient page navigation, or they can be used to customize and enhance the user’s experience by remembering language preferences, login credentials, and more. They can also be used to provide anonymous statistical data about the usage of the website or targeted advertisements to the visitor.</p><p>Some sites might also use other similar technologies like web beacons, clear GIFs, page tags, and web bugs to understand how people are using them and to target advertising to them. They usually take the form of a small, transparent image that is embedded in a web page or email. They work with cookies and capture data like your IP address, when you viewed the page or email, what device you were using, and where you were.</p><p><br></p><h3>TYPES OF COOKIES</h3><p>Cookies can be classified as First-party Cookies and Third-party Cookies.</p><ul><li><strong>First-party Cookies</strong>: These are set by the website you are visiting. They help provide a seamless experience by remembering your preferences as you navigate through the site.</li><li><strong>Third-party Cookies</strong>: These are set by other entities to track your online behavior across different websites. For example, advertising networks use these cookies to display targeted ads.</li></ul><p><br></p><h3>COOKIES CATEGORIES</h3><p>Cookies are usually categorized into one of the following categories, depending on their purpose:</p><ul><li><strong>Necessary Cookies</strong>: These cookies are essential for the website to function properly. They enable basic functions like page navigation and access to secure areas of the website. These cookies do not require your consent.</li><li><strong>Preference or Functionality Cookies</strong>: These cookies allow the website to remember choices you have made in the past, such as your preferred language or the region you are in.</li><li><strong>Statistics or Performance Cookies</strong>: These cookies help website owners understand how visitors interact with their website by collecting and reporting information anonymously.</li><li><strong>Marketing Cookies</strong>: These cookies are used to track visitors across websites. The intention is to display ads that are relevant and engaging for the individual user and thereby more valuable for publishers and third-party advertisers.</li></ul><p><br></p><h3>HOW LONG DO COOKIES LAST?</h3><p>Depending on the duration that a cookie is stored on the user’s device, cookies can be classified as:</p><ul><li><strong>Session Cookies</strong>: These are temporary cookies that are deleted when you close your browser.</li><li><strong>Persistent Cookies</strong>: These cookies remain on your device for a specified period of time, which could range from minutes to years.</li></ul><p><br></p><h3>HOW TO CONTROL COOKIES ON THIS WEBSITE</h3><p>StoreKing will only set cookies after you have provided your consent to the use of cookies through the cookies banner upon your visit to our website. For necessary cookies, we do not need your consent.</p><p>You have the right to withdraw your consent or change your preferences regarding the use of cookies at any time. You can do this by accessing our cookies banner through the “Cookie Settings” button.</p><p><br></p><h3>YOUR RIGHTS</h3><p>If you have a concern about the way we are collecting or using cookies, you should raise your concern with us in the first instance or directly to the office of the Commissioner for the Protection of Private Data.</p>',
                    'menu_section_id'  => 2,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Terms & Conditions',
                    'slug'             => 'terms-and-conditions',
                    'description'      => '<p>Welcome to StoreKing. These terms and conditions outline the rules and regulations for the use of StoreKing website and services.</p><p><br></p><p>By accessing this website, we assume you accept these terms and conditions. Do not continue to use StoreKing if you do not agree to all of the terms and conditions stated on this page.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">1.</span> Introduction</h3><p>These terms and conditions govern your use of our website and services. By using our website, you accept these terms in full. If you disagree with any part of these terms and conditions, do not use our website.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">2.</span> Intellectual Property Rights</h3><p>Unless otherwise stated, StoreKing and/or its licensors own the intellectual property rights for all material on StoreKing. All intellectual property rights are reserved. You may access this from StoreKing for your own personal use, subject to restrictions set in these terms and conditions.</p><p><br></p><p>You must not:</p><p><br></p><ul><li>Republish material from StoreKing</li><li>Sell, rent, or sub-license material from StoreKing</li><li>Reproduce, duplicate, or copy material from StoreKing</li><li>Redistribute content from StoreKing</li></ul><p><br></p><h3><span style="color: rgb(103, 150, 230);">3.</span> User Accounts</h3><p>To access certain features of our website, you may need to create an account. You must ensure that the details you provide us are accurate and up-to-date. You are responsible for maintaining the confidentiality of your account information and password. You agree to accept responsibility for all activities that occur under your account.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">4.</span> Order Acceptance and Pricing</h3><p>All orders placed through our website are subject to acceptance by StoreKing. We may, at our sole discretion, refuse or cancel any order for any reason. In the event of an error in pricing, we reserve the right to cancel any orders placed at the incorrect price.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">5.</span> Payment and Billing Information</h3><p>By providing a payment method, you represent that you are authorized to use the payment method provided and authorize us to charge your payment method for the total amount of your order. If the payment method cannot be verified, is invalid, or is otherwise not acceptable, your order may be suspended or cancelled.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">6.</span> Delivery and Shipping</h3><p>We will make every effort to deliver your order within the estimated delivery times provided at the time of purchase. However, we are not responsible for any delays in delivery which are beyond our control. Risk of loss and title for products purchased from StoreKing pass to you upon delivery of the items to the carrier.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">7.</span> Returns and Refunds</h3><p>We want you to be completely satisfied with your purchase. If you are not satisfied, you may return most items within 30 days of receipt for a full refund, subject to our Return Policy. Certain items are non-returnable or subject to a restocking fee. Please refer to our Return Policy for more details.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">8.</span> Limitation of Liability</h3><p>To the fullest extent permitted by law, StoreKing shall not be liable for any indirect, incidental, special, consequential, or punitive damages, or any loss of profits or revenues, whether incurred directly or indirectly, or any loss of data, use, goodwill, or other intangible losses, resulting from your use of the website or our services.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">9.</span> Indemnification</h3><p>You agree to indemnify, defend, and hold harmless StoreKing, its officers, directors, employees, agents, and suppliers from and against all claims, losses, expenses, damages, and costs, including reasonable attorneys fees, resulting from any violation of these terms and conditions or any activity related to your account by you or any other person accessing the website using your account.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">10.</span> Governing Law</h3><p>These terms and conditions are governed by and construed in accordance with the laws of [Your Country/State], and you irrevocably submit to the exclusive jurisdiction of the courts in that location.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">11.</span> Changes to These Terms</h3><p>StoreKing reserves the right to amend these terms and conditions at any time. All changes will be effective immediately upon posting on our website. Your continued use of our website and services after any changes have been made constitutes acceptance of those changes.</p><p><br></p><h3><span style="color: rgb(103, 150, 230);">12.</span> Contact Us</h3><p>If you have any questions about these terms and conditions, please contact us.</p><p><br></p><p>Thank you for choosing StoreKing. We hope you enjoy your shopping experience with us.</p>',
                    'menu_section_id'  => 2,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Privacy Policy',
                    'slug'             => 'privacy-policy',
                    'description'      => '<p>This privacy policy describes the personal data collected or generated (processed) when you interact with StoreKing through our websites, digital experiences, mobile applications, stores, events, or one of our other products or services, all of which are part of StoreKing’s Platform (“Platform”). It also explains how your personal data is used, shared, and protected, what choices you have relating to your personal data, and how you can contact us.</p><p><br></p><h3>WHO is Responsible for the Processing of Your Personal Data?</h3><p>The StoreKing entity responsible for the processing of your personal data will depend on how you interact with StoreKing’s Platform and where you are located in the world.</p><p><br></p><p>Please review our List of Local Entities for the name of the StoreKing entity responsible and the appropriate contact information.</p><p><br></p><h3>WHAT Personal Data Do We Collect and WHEN?</h3><p>We ask you for certain personal data to provide you with the products or services you request. For example, when you make purchases, contact our customer services, request to receive communications, create an account, participate in our events or contests, or use our Platform. Additionally, when you request specific services in-store, we may ask you to log in to provide services that are then associated with your account (e.g. preferences, purchase history).</p><p><br></p><p>This personal data includes your:</p><p><br></p><ul><li>Contact details including name, email, telephone number, and shipping and billing address</li><li>Login and account information, including screen name, password, and unique user ID</li><li>Personal details including gender, hometown, date of birth, and purchase history</li><li>Payment or credit card information</li><li>Images, photos, and videos</li><li>Personal preferences including your wish list as well as marketing and cookie preferences</li></ul><p><br></p><p>We collect additional personal data from you to enable particular features within our Platform. For example, we request access to your phone’s location data to provide location-based services or your social network credentials to post content from our Platform to a social network. This personal data includes your:</p><p><br></p><ul><li>Photos, audio, and contacts</li><li>Social network information, including credentials and any information from your public posts about StoreKing or your communications with us</li></ul><p><br></p><p>When interacting with our Platform, certain data is automatically collected from your device or web browser. More information about these practices is included in the “Cookies and Pixel Tags” section of this privacy policy below. This data includes:</p><p><br></p><ul><li>Device IDs and type, call state, network access, storage information, and battery information</li><li>Traffic data about your visit to and interactions with our Platform, including products you viewed, added to your cart, or searched for, and whether you are logged in to your StoreKing account</li><li>Cookies, IP addresses, referrer headers, data identifying your web browser and version, web beacons, tags, and interactions with our Platform</li></ul><p><br></p><h3>HOW is Your Personal Data Used?</h3><p>We use the personal data we collect from you in the following ways:</p><p><br></p><ul><li>To provide the products and services you request</li><li>To communicate with you about your orders, account, or customer service inquiries</li><li>To send you promotional messages and other information about StoreKing products, services, and events</li><li>To improve our Platform, products, and services</li><li>To personalize your experience on our Platform</li><li>To conduct research and analysis</li></ul><p><br></p><h3>HOW is Your Personal Data Shared?</h3><p>We share your personal data with:</p><p><br></p><ul><li>Third-party service providers who process data on our behalf, such as payment processors, delivery services, and customer support</li><li>Business partners, where necessary to provide our products and services</li><li>Authorities, if required by law or to protect our legal rights</li></ul><p><br></p><h3>HOW is Your Personal Data Protected?</h3><p>We implement various security measures to protect your personal data, including encryption, access controls, and regular security assessments.</p><p><br></p><h3>WHAT Choices Do You Have?</h3><p>You have the right to access, correct, or delete your personal data, as well as the right to object to or restrict certain processing of your data. You can exercise these rights by contacting us through the contact information provided in the List of Local Entities.</p><p><br></p><h3>Cookies and Pixel Tags</h3><p>Our Platform uses cookies and similar technologies to enhance your browsing experience, analyze site traffic, and personalize content. You can manage your cookie preferences through your browser settings.</p><p><br></p><h3>Contact Us</h3><p>If you have any questions or concerns about our privacy policy or how your personal data is handled, please contact us or review our List of Local Entities for the appropriate contact information.</p><p><br></p><p>Thank you for trusting StoreKing with your personal data. We are committed to protecting your privacy and providing a safe and secure shopping experience.</p>',
                    'menu_section_id'  => 2,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],

            ]);
        }
    }
}
