<?php

namespace Database\Seeders;

use App\Enums\Ask;
use Carbon\Carbon;
use App\Enums\Status;
use App\Enums\Activity;
use App\Models\Product;
use App\Models\ProductSeo;
use App\Models\ProductTag;
use App\Models\ProductTax;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Dipokhalder\EnvEditor\EnvEditor;
use Picqer\Barcode\BarcodeGeneratorJPG;

class ProductTableSeeder extends Seeder
{
    public function run(): void
    {
        $groceryProducts = [

            //  Fresh Vegetables
            [
                'info' => [
                    'name' => 'Local Onion',
                    'category' => 3,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 15,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Local Onion',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            [
                'info' => [
                    'name' => 'Cauliflower',
                    'category' => 3,
                    'brand' => 2,
                    'unit_id' => 1,
                    'buying_price' => 30,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Cauliflower',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            [
                'info' => [
                    'name' => 'Potato Regular',
                    'category' => 3,
                    'brand' => 3,
                    'unit_id' => 3,
                    'buying_price' => 5,
                    'selling_price' => 10,
                    'variation_price' => 10,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Potato Regular',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            [
                'info' => [
                    'name' => 'Ladies Finger',
                    'category' => 3,
                    'brand' => 4,
                    'unit_id' => 3,
                    'buying_price' => 13,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",

                ],
                'seo' => [
                    'title' => 'Ladies Finger',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            [
                'info' => [
                    'name' => 'Red Tomato',
                    'category' => 3,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 24,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Red Tomato',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            [
                'info' => [
                    'name' => 'Cucumber',
                    'category' => 3,
                    'brand' => 6,
                    'unit_id' => 3,
                    'buying_price' => 26,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Cucumber',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            [
                'info' => [
                    'name' => 'Coriander Leaves',
                    'category' => 3,
                    'brand' => 4,
                    'unit_id' => 2,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Coriander Leaves',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],
            [
                'info' => [
                    'name' => 'Onion Red',
                    'category' => 3,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 15,
                    'selling_price' => 24,
                    'variation_price' => 24,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Onion Red',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],
            [
                'info' => [
                    'name' => 'Garlic',
                    'category' => 3,
                    'brand' => 1,
                    'unit_id' => 3,
                    'buying_price' => 10,
                    'selling_price' => 15,
                    'variation_price' => 15,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Garlic',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],
            [
                'info' => [
                    'name' => 'Ginger',
                    'category' => 3,
                    'brand' => 2,
                    'unit_id' => 2,
                    'buying_price' => 12,
                    'selling_price' => 15,
                    'variation_price' => 15,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->startOfDay(),
                    'offer_end_date' => Carbon::now()->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Ginger',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],
            [
                'info' => [
                    'name' => 'Local Carrot',
                    'category' => 3,
                    'brand' => 3,
                    'unit_id' => 3,
                    'buying_price' => 44,
                    'selling_price' => 55,
                    'variation_price' => 55,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Local Carrot',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            [
                'info' => [
                    'name' => 'Sweet Pumpkin',
                    'category' => 3,
                    'brand' => 3,
                    'unit_id' => 3,
                    'buying_price' => 43,
                    'selling_price' => 55,
                    'variation_price' => 55,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Sweet Pumpkin',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            [
                'info' => [
                    'name' => 'Green Spinach',
                    'category' => 3,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->startOfDay(),
                    'offer_end_date' => Carbon::now()->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Green Spinach',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            [
                'info' => [
                    'name' => 'Capsicum',
                    'category' => 3,
                    'brand' => 6,
                    'unit_id' => 3,
                    'buying_price' => 15,
                    'selling_price' => 22,
                    'variation_price' => 22,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Capsicum',
                    'meta_keyword' => ['Fresh', 'Vegetables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Fresh', 'Vegetables'],
                'image_path' => 'food/fruits_&_vegetables/fresh_vegetables',
            ],

            // Fresh Fruits
            [
                'info' => [
                    'name' => 'Green Grapes',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 80,
                    'selling_price' => 100,
                    'variation_price' => 100,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Green Grapes',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every 500 gm of the product will contain 7-10 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Green', 'Grapes'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Guava Premium',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 60,
                    'selling_price' => 80,
                    'variation_price' => 80,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 20,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Guava Premium',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Guava', 'Premium'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Orange',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 150,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(1)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(1)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Orange',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Orange'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Watermelon',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 500,
                    'selling_price' => 600,
                    'variation_price' => 600,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(1)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(1)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every pcs weight is 2 to 5 kilograms.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Watermelon',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every pcs weight is 2 to 5 kilograms.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Watermelon'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Green Apple',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 300,
                    'variation_price' => 300,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Green Apple',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Green', 'Apple'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'China Fuji Apple',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 350,
                    'selling_price' => 400,
                    'variation_price' => 400,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'China Fuji Apple',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['China Fuji', 'Apple'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Pomegranate',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 350,
                    'selling_price' => 400,
                    'variation_price' => 400,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(2)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(2)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Pomegranate',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Pomegranate'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Cherry Pineapple',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 200,
                    'selling_price' => 300,
                    'variation_price' => 300,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every pcs weight is 2 to 5 kilograms.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Cherry Pineapple',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every pcs weight is 2 to 5 kilograms.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Cherry', 'Pineapple'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Java Apple Red',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 350,
                    'selling_price' => 400,
                    'variation_price' => 400,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Java Apple Red',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every 500 gm of the product will contain 2-4 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Java', 'Apple Red'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Lychee Premium',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 150,
                    'selling_price' => 500,
                    'variation_price' => 500,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(2)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(2)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>The Bundle contains 100 pcs lychee.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Lychee Premium',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>The Bundle contains 100 pcs lychee.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Lychee Premium'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Banana',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 80,
                    'selling_price' => 100,
                    'variation_price' => 100,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>The Bundle contains 10-15 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Banana',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>The Bundle contains 100 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => [' Banana'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Papaya',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 500,
                    'selling_price' => 600,
                    'variation_price' => 600,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(3)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(3)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every pcs weight is 1 to 3 kilograms.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Papaya',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every pcs weight is 1 to 3 kilograms.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Papaya'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Red Grape',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 80,
                    'selling_price' => 100,
                    'variation_price' => 100,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 20-50 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Red Grape',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every 500 gm of the product will contain 20-50 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Green', 'Grape'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],
            [
                'info' => [
                    'name' => 'Mango',
                    'category' => 4,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 80,
                    'selling_price' => 100,
                    'variation_price' => 100,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(4)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(4)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Every 500 gm of the product will contain 2-3 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'seo' => [
                    'title' => 'Mango',
                    'meta_keyword' => ['Fruits', 'Vegitables'],
                    'description' => "<p>Every 500 gm of the product will contain 2-3 pcs.</p><p>The item is consumed in diverse ways, including raw, as an ingredient in many dishes, sauces, salads, and drinks. While it is botanically a fruit, it is considered a vegetable for culinary purposes. The fruit is rich in lycopene, which may have beneficial health effects.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Mango'],
                'image_path' => 'food/fruits_&_vegetables/fresh_fruits',
            ],

            // Nuts & Dry Fruits
            [
                'info' => [
                    'name' => 'Pistachio',
                    'category' => 5,
                    'brand' => 4,
                    'unit_id' => 3,
                    'buying_price' => 18,
                    'selling_price' => 23,
                    'variation_price' => 23,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Pistachio',
                    'meta_keyword' => ['Fresh', 'Dry Fruits'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Fresh', 'Dry Fruits'],
                'image_path' => 'food/fruits_&_vegetables/nuts_&_dry_fruits',
            ],
            [
                'info' => [
                    'name' => 'Walnuts',
                    'category' => 5,
                    'brand' => 1,
                    'unit_id' => 3,
                    'buying_price' => 21,
                    'selling_price' => 27,
                    'variation_price' => 27,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Walnuts',
                    'meta_keyword' => ['Fresh', 'Dry Fruits'],
                    'description' => "<p><p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Fresh', 'Dry Fruits'],
                'image_path' => 'food/fruits_&_vegetables/nuts_&_dry_fruits',
            ],
            [
                'info' => [
                    'name' => 'Peanut Peeled',
                    'category' => 5,
                    'brand' => 2,
                    'unit_id' => 3,
                    'buying_price' => 24,
                    'selling_price' => 29,
                    'variation_price' => 29,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Peanut Peeled',
                    'meta_keyword' => ['Fresh', 'Dry Fruits'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Fresh', 'Dry Fruits'],
                'image_path' => 'food/fruits_&_vegetables/nuts_&_dry_fruits',
            ],

            [
                'info' => [
                    'name' => 'Raisins',
                    'category' => 5,
                    'brand' => 3,
                    'unit_id' => 3,
                    'buying_price' => 30,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(4)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(4)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Raisins',
                    'meta_keyword' => ['Fresh', 'Dry Fruits'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Fresh', 'Dry Fruits'],
                'image_path' => 'food/fruits_&_vegetables/nuts_&_dry_fruits',
            ],

            [
                'info' => [
                    'name' => 'Cashew Nut',
                    'category' => 5,
                    'brand' => 4,
                    'unit_id' => 3,
                    'buying_price' => 8,
                    'selling_price' => 14,
                    'variation_price' => 14,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Cashew Nut',
                    'meta_keyword' => ['Fresh', 'Dry Fruits'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Fresh', 'Dry Fruits'],
                'image_path' => 'food/fruits_&_vegetables/nuts_&_dry_fruits',
            ],
            [
                'info' => [
                    'name' => 'Almonds',
                    'category' => 5,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 6,
                    'selling_price' => 18,
                    'variation_price' => 18,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Almonds',
                    'meta_keyword' => ['Fresh', 'Dry Fruits'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Fresh', 'Dry Fruits'],
                'image_path' => 'food/fruits_&_vegetables/nuts_&_dry_fruits',
            ],
            [
                'info' => [
                    'name' => 'Green Peas',
                    'category' => 5,
                    'brand' => 6,
                    'unit_id' => 3,
                    'buying_price' => 6,
                    'selling_price' => 16,
                    'variation_price' => 16,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Green Peas',
                    'meta_keyword' => ['Fresh', 'Dry Fruits'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Fresh', 'Dry Fruits'],
                'image_path' => 'food/fruits_&_vegetables/nuts_&_dry_fruits',
            ],

            // Chicken
            [
                'info' => [
                    'name' => 'Whole Chicken',
                    'category' => 7,
                    'brand' => 1,
                    'unit_id' => 6,
                    'buying_price' => 14,
                    'selling_price' => 16,
                    'variation_price' => 16,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Whole Chicken',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],
            [
                'info' => [
                    'name' => 'Roasted Chicken',
                    'category' => 7,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 12,
                    'selling_price' => 22,
                    'variation_price' => 22,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Roasted Chicken',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],
            [
                'info' => [
                    'name' => 'Chicken Breast Boneless',
                    'category' => 7,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 13,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Chicken Breast Boneless',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],
            [
                'info' => [
                    'name' => 'Buffalo Wings',
                    'category' => 7,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 25,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(5)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(5)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Buffalo Wings',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],
            [
                'info' => [
                    'name' => 'Chicken Breast Tenderloins',
                    'category' => 7,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 10,
                    'selling_price' => 20,
                    'variation_price' => 20,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Chicken Breast Tenderloins',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],
            [
                'info' => [
                    'name' => 'Chicken Drumsticks',
                    'category' => 7,
                    'brand' => 6,
                    'unit_id' => 6,
                    'buying_price' => 20,
                    'selling_price' => 30,
                    'variation_price' => 30,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Chicken Drumsticks',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],
            [
                'info' => [
                    'name' => 'Chicken Thigh Boneless',
                    'category' => 7,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 25,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Chicken Thigh Boneless',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],
            [
                'info' => [
                    'name' => 'Chicken Party Wings',
                    'category' => 7,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 23,
                    'selling_price' => 28,
                    'variation_price' => 28,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(5)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(5)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Chicken Party Wings',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],
            [
                'info' => [
                    'name' => 'Ground Chicken',
                    'category' => 7,
                    'brand' => 1,
                    'unit_id' => 6,
                    'buying_price' => 12,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Ground Chicken',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],
            [
                'info' => [
                    'name' => 'Chicken Liver Gizzard',
                    'category' => 7,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 22,
                    'selling_price' => 27,
                    'variation_price' => 27,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(6)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(6)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'seo' => [
                    'title' => 'Chicken Liver Gizzard',
                    'meta_keyword' => ['Chicken'],
                    'description' => "<p>Chickens are raised primarily for meat rather than to lay eggs. These poultry are often white and are bred to be large and very healthy, often with more breast meat for the consumer market. Broiler chicken breeds grow very fast and offer good value in terms of protein and calories.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Chicken'],
                'image_path' => 'food/meat_&_fish/chicken',
            ],

            // Beef

            [
                'info' => [
                    'name' => 'Beef Meat',
                    'category' => 8,
                    'brand' => 2,
                    'unit_id' => 3,
                    'buying_price' => 30,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(7)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(7)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Beef Meat',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],

            [
                'info' => [
                    'name' => 'Ground Beef Steak Burgers',
                    'category' => 8,
                    'brand' => 1,
                    'unit_id' => 3,
                    'buying_price' => 32,
                    'selling_price' => 37,
                    'variation_price' => 37,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Ground Beef Steak Burgers',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],
            [
                'info' => [
                    'name' => 'Ground Beef',
                    'category' => 8,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 33,
                    'selling_price' => 40,
                    'variation_price' => 40,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Ground Beef',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],
            [
                'info' => [
                    'name' => 'Beef Liver',
                    'category' => 8,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 34,
                    'selling_price' => 44,
                    'variation_price' => 44,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(8)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(8)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Beef Liver',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],
            [
                'info' => [
                    'name' => 'Beef Short Ribs',
                    'category' => 8,
                    'brand' => 4,
                    'unit_id' => 3,
                    'buying_price' => 35,
                    'selling_price' => 43,
                    'variation_price' => 43,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Beef Short Ribs',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],
            [
                'info' => [
                    'name' => 'Beef Milanesa',
                    'category' => 8,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 12,
                    'selling_price' => 17,
                    'variation_price' => 17,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Beef Milanesa',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],
            [
                'info' => [
                    'name' => 'Beef Chuck Shaved',
                    'category' => 8,
                    'brand' => 6,
                    'unit_id' => 3,
                    'buying_price' => 15,
                    'selling_price' => 20,
                    'variation_price' => 20,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Beef Chuck Shaved',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],
            [
                'info' => [
                    'name' => 'Butcher Lamb Shank',
                    'category' => 8,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 20,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Butcher Lamb Shank',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],
            [
                'info' => [
                    'name' => 'Beef Ribeye',
                    'category' => 8,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 30,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(8)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(8)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Beef Ribeye',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],
            [
                'info' => [
                    'name' => 'Beef T-bone Steak',
                    'category' => 8,
                    'brand' => 1,
                    'unit_id' => 6,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Beef T-bone Steak',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],
            [
                'info' => [
                    'name' => 'Beef Sirloin Steak',
                    'category' => 8,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 45,
                    'selling_price' => 55,
                    'variation_price' => 55,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(9)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(9)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'seo' => [
                    'title' => 'Beef Sirloin Steak',
                    'meta_keyword' => ['Beef', 'Meat'],
                    'description' => "<p>Premium quality locally sourced. Meat, such as beef, is mainly composed of protein. Usually eaten as roasts, ribs, or steaks, beef is also commonly ground or minced. Patties of ground beef are often used in hamburgers. Processed beef products include corned beef, beef jerky, and sausages. Fresh lean beef is rich in various vitamins and minerals, especially iron and zinc, and is therefore recommended as part of a healthy diet.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Beef', 'Meat'],
                'image_path' => 'food/meat_&_fish/beef',
            ],

            // Frozen Fish
            [
                'info' => [
                    'name' => 'Rainbow Trout',
                    'category' => 9,
                    'brand' => 3,
                    'unit_id' => 3,
                    'buying_price' => 40,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'seo' => [
                    'title' => 'Rainbow Trout',
                    'meta_keyword' => ['Frozen', 'Fish'],
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Frozen', 'Fish'],
                'image_path' => 'food/meat_&_fish/frozen_fish',
            ],
            [
                'info' => [
                    'name' => 'Alaskan Pink Salmon',
                    'category' => 9,
                    'brand' => 4,
                    'unit_id' => 3,
                    'buying_price' => 48,
                    'selling_price' => 54,
                    'variation_price' => 54,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'seo' => [
                    'title' => 'Alaskan Pink Salmon',
                    'meta_keyword' => ['Frozen', 'Fish'],
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Frozen', 'Fish'],
                'image_path' => 'food/meat_&_fish/frozen_fish',
            ],
            [
                'info' => [
                    'name' => 'Extra Large Shrimp',
                    'category' => 9,
                    'brand' => 5,
                    'unit_id' => 3,
                    'buying_price' => 23,
                    'selling_price' => 29,
                    'variation_price' => 29,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'seo' => [
                    'title' => 'Extra Large Shrimp',
                    'meta_keyword' => ['Frozen', 'Fish'],
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Frozen', 'Fish'],
                'image_path' => 'food/meat_&_fish/frozen_fish',
            ],
            [
                'info' => [
                    'name' => 'Frozen Tilapia Skinless',
                    'category' => 31,
                    'brand' => 6,
                    'unit_id' => 3,
                    'buying_price' => 25,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(9)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(9)->endOfDay(),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'seo' => [
                    'title' => 'Frozen Tilapia Skinless',
                    'meta_keyword' => ['Frozen', 'Fish'],
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Frozen', 'Fish'],
                'image_path' => 'food/meat_&_fish/frozen_fish',
            ],
            [
                'info' => [
                    'name' => 'Atlantic Salmon',
                    'category' => 31,
                    'brand' => 4,
                    'unit_id' => 3,
                    'buying_price' => 12,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'seo' => [
                    'title' => 'Atlantic Salmon',
                    'meta_keyword' => ['Frozen', 'Fish'],
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Frozen', 'Fish'],
                'image_path' => 'food/meat_&_fish/frozen_fish',
            ],
            [
                'info' => [
                    'name' => 'Wild Caught Flounder',
                    'category' => 31,
                    'brand' => 5,
                    'unit_id' => 3,
                    'buying_price' => 15,
                    'selling_price' => 20,
                    'variation_price' => 20,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'seo' => [
                    'title' => 'Wild Caught Flounder',
                    'meta_keyword' => ['Frozen', 'Fish'],
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Frozen', 'Fish'],
                'image_path' => 'food/meat_&_fish/frozen_fish',
            ],
            [
                'info' => [
                    'name' => 'Aquamar Surimi',
                    'category' => 31,
                    'brand' => 1,
                    'unit_id' => 3,
                    'buying_price' => 33,
                    'selling_price' => 44,
                    'variation_price' => 44,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'sell_by_fraction' => Ask::YES,
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'seo' => [
                    'title' => 'Aquamar Surimi',
                    'meta_keyword' => ['Frozen', 'Fish'],
                    'description' => "<p>The Wild Caught Alaska Sockeye Salmon Portions are sure to become a family favorite. It is rich in Omega-3s, packed with 25g of protein per 4 oz. (113 g) serving, and low in calories, making it the perfect heart healthy and delicious addition to your diet. Our Wild Caught Alaska Sockeye Salmon is Marine Stewardship Council (MSC) certified, ensuring that your delicious meal is responsibly sourced. Popular for its versatility, Sockeye Salmon's unique and mild, delicate flavor goes well with a wide variety of seasonings.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Frozen', 'Fish'],
                'image_path' => 'food/meat_&_fish/frozen_fish',
            ],

            // Food ->  Sauces & Pickles -> Tomato Sauce

            [
                'info' => [
                    'name' => 'Tomato Sauce 15 oz',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 80,
                    'selling_price' => 100,
                    'variation_price' => 100,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(10)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(10)->endOfDay(),
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => 'Tomato Sauce 15 oz',
                    'meta_keyword' => ['Tomato', 'Sauce'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Tomato', 'Sauce'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],
            [
                'info' => [
                    'name' => 'Tomato Sauce 29 oz',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 85,
                    'selling_price' => 110,
                    'variation_price' => 110,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => 'Tomato Sauce 29 oz',
                    'meta_keyword' => ['Tomato', 'Sauce'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Tomato', 'Sauce'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],
            [
                'info' => [
                    'name' => 'Canned Tomato Sauce 15 oz',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 90,
                    'selling_price' => 120,
                    'variation_price' => 120,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(10)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(10)->endOfDay(),
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => ' Canned Tomato Sauce 15 oz',
                    'meta_keyword' => ['Tomato', 'Sauce'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Canned', 'Tomato', 'Sauce'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],
            [
                'info' => [
                    'name' => 'Contadina Tomato Puree',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 100,
                    'selling_price' => 120,
                    'variation_price' => 120,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => ' Contadina Tomato Puree',
                    'meta_keyword' => ['Tomato', 'Sauce'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Contadina', 'Tomato', 'Puree'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],
            [
                'info' => [
                    'name' => 'Tomato Basil Sauce 24 oz',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 110,
                    'selling_price' => 130,
                    'variation_price' => 130,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => ' Tomato Basil Sauce, 24 oz',
                    'meta_keyword' => ['Tomato', 'Sauce'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Basil', 'Tomato', 'Sauce'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],
            [
                'info' => [
                    'name' => 'Tomato Sauce 8 oz Can',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 100,
                    'selling_price' => 120,
                    'variation_price' => 120,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(11)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(11)->endOfDay(),
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => 'Tomato Sauce, 8 oz Can',
                    'meta_keyword' => ['Tomato', 'Sauce'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Tomato', 'Sauce', 'oz'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],
            [
                'info' => [
                    'name' => 'No Salt Tomato Sauce 8 oz',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 120,
                    'selling_price' => 140,
                    'variation_price' => 140,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => ' No Salt Tomato Sauce, 8 oz',
                    'meta_keyword' => ['Tomato', 'Sauce'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['No Salt', 'Tomato', 'Sauce', 'oz'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],
            [
                'info' => [
                    'name' => 'Organic Tomato Sauce 15 oz',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 130,
                    'selling_price' => 150,
                    'variation_price' => 150,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(11)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(11)->endOfDay(),
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => 'Organic Tomato Sauce, 15 oz',
                    'meta_keyword' => ['Tomato', 'Sauce'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Organic', 'Tomato', 'Sauce', 'oz'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],
            [
                'info' => [
                    'name' => 'Tomato Paste 6 oz',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 110,
                    'selling_price' => 130,
                    'variation_price' => 130,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => 'Tomato Paste, 6 oz',
                    'meta_keyword' => ['Tomato', 'Paste'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Tomato', 'Paste', 'oz'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],
            [
                'info' => [
                    'name' => 'Traditional Pasta Sauce',
                    'category' => 11,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 120,
                    'selling_price' => 180,
                    'variation_price' => 180,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(12)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(12)->endOfDay(),
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'seo' => [
                    'title' => 'Traditional Pasta Sauce',
                    'meta_keyword' => ['Tomato', 'Paste'],
                    'description' => "<p>Upgrade mealtime, anytime with Great Value Tomato Sauce. To create this hearty sauce, California farmers pick field-grown tomatoes at the peak of freshness and can them within 5 hours of harvest to preserve their freshness and flavor. Elevate your pasta marinara, create an aromatic chutney, or upgrade a grilled cheese with a thin layer of this sauce spread across crusty baked bread. The culinary possibilities are virtually endless when you have a can of Great Value Tomato Sauce in your pantry.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Traditional', 'Paste', 'Sauce'],
                'image_path' => 'food/sauces_&_pickles/tomato_sauce',
            ],

            // Food ->  Sauces & Pickles -> Pickles

            [
                'info' => [
                    'name' => 'Dill Pickle Snacking Cuts',
                    'category' => 12,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 120,
                    'selling_price' => 180,
                    'variation_price' => 180,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'seo' => [
                    'title' => 'Dill Pickle Snacking Cuts',
                    'meta_keyword' => ['Pickles'],
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'taxes' => [1],
                'tags' => ['Dill', 'Pickle', 'Snacking', 'Cuts'],
                'image_path' => 'food/sauces_&_pickles/pickles',
            ],
            [
                'info' => [
                    'name' => 'Hot N Spicy Pickle Snacking Cuts',
                    'category' => 12,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 150,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(12)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(12)->endOfDay(),
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'seo' => [
                    'title' => 'Hot N Spicy Pickle Snacking Cuts',
                    'meta_keyword' => ['Pickles'],
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Hot N', 'Pickle', 'Snacking', 'Cuts'],
                'image_path' => 'food/sauces_&_pickles/pickles',
            ],
            [
                'info' => [
                    'name' => 'Dill Pickle Fresh Pack',
                    'category' => 12,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 150,
                    'selling_price' => 210,
                    'variation_price' => 210,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'seo' => [
                    'title' => 'Dill Pickle Fresh Pack',
                    'meta_keyword' => ['Pickles'],
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Dill', 'Pickle', 'Fresh', 'Pack'],
                'image_path' => 'food/sauces_&_pickles/pickles',
            ],
            [
                'info' => [
                    'name' => 'Dill Pickle Spears',
                    'category' => 12,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 100,
                    'selling_price' => 260,
                    'variation_price' => 260,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'seo' => [
                    'title' => 'Dill Pickle Spears',
                    'meta_keyword' => ['Pickles'],
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Dill', 'Pickle', 'Spears'],
                'image_path' => 'food/sauces_&_pickles/pickles',
            ],
            [
                'info' => [
                    'name' => 'Mini Dill Pickles',
                    'category' => 12,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 100,
                    'selling_price' => 120,
                    'variation_price' => 120,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'seo' => [
                    'title' => 'Mini Dill Pickles',
                    'meta_keyword' => ['Pickles'],
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Dill', 'Pickle', 'Pickles'],
                'image_path' => 'food/sauces_&_pickles/pickles',
            ],
            [
                'info' => [
                    'name' => 'Sweet N Spicy Pickle Chips',
                    'category' => 12,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 100,
                    'selling_price' => 120,
                    'variation_price' => 120,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(13)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(13)->endOfDay(),
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'seo' => [
                    'title' => 'Sweet N Spicy Pickle Chips',
                    'meta_keyword' => ['Pickles'],
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Sweet N', 'Spicy', 'Pickle', 'Chips'],
                'image_path' => 'food/sauces_&_pickles/pickles',
            ],
            [
                'info' => [
                    'name' => 'Hamburger Dill Pickle Chips',
                    'category' => 12,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 90,
                    'selling_price' => 130,
                    'variation_price' => 130,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'seo' => [
                    'title' => 'Hamburger Dill Pickle Chips',
                    'meta_keyword' => ['Pickles'],
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'taxes' => [1],
                'tags' => ['Hamburger', 'Dill', 'Pickle', 'Chips'],
                'image_path' => 'food/sauces_&_pickles/pickles',
            ],
            [
                'info' => [
                    'name' => 'Hamburger Slices Pickles',
                    'category' => 12,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 150,
                    'selling_price' => 170,
                    'variation_price' => 170,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(14)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(14)->endOfDay(),
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'seo' => [
                    'title' => 'Hamburger Slices Pickles',
                    'meta_keyword' => ['Pickles'],
                    'description' => "<p>Treat yourself to the tasty crunch of OH SNAP! Dilly Bites Dill Pickle Snacking Cut. Yes, they're crunchy, delicious, and healthy--everything you love about pickles. However, OH SNAP! Dilly Bites are refrigerated and have no added brine, so there's less mess. Plus, they come in a single-serve pouch with 98 grams of pickle goodness, so you can enjoy them with a meal or as a refreshing snack on the road, in a school lunch, or … right now!</p>",
                ],
                'taxes' => [1],
                'tags' => ['Hamburger', 'Slices', 'Pickle'],
                'image_path' => 'food/sauces_&_pickles/pickles',
            ],

            // Food ->  Sauces & Pickles -> Cooking Sauce

            [
                'info' => [
                    'name' => 'Butter Chicken Simmer Sauce',
                    'category' => 13,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 150,
                    'selling_price' => 170,
                    'variation_price' => 170,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(14)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(14)->endOfDay(),
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'seo' => [
                    'title' => 'Butter Chicken Simmer Sauce',
                    'meta_keyword' => ['Cooking', 'Sauce'],
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Butter Chicken', 'Simmer Sauce'],
                'image_path' => 'food/sauces_&_pickles/cooking_sauce',
            ],
            [
                'info' => [
                    'name' => 'Cooking Sauces & Marinades',
                    'category' => 13,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 120,
                    'selling_price' => 155,
                    'variation_price' => 155,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'seo' => [
                    'title' => 'Cooking Sauces & Marinades',
                    'meta_keyword' => ['Cooking', 'Sauce'],
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Cooking Sauces', 'Marinades'],
                'image_path' => 'food/sauces_&_pickles/cooking_sauce',
            ],
            [
                'info' => [
                    'name' => 'Loisa Recaito Cooking Sauce',
                    'category' => 13,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 120,
                    'selling_price' => 155,
                    'variation_price' => 155,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(15)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(15)->endOfDay(),
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'seo' => [
                    'title' => 'Loisa Recaito Cooking Sauce',
                    'meta_keyword' => ['Cooking', 'Sauce'],
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Loisa Recaito', 'Cooking Sauce'],
                'image_path' => 'food/sauces_&_pickles/cooking_sauce',
            ],
            [
                'info' => [
                    'name' => 'Teriyaki Marinade',
                    'category' => 13,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 115,
                    'selling_price' => 135,
                    'variation_price' => 135,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'seo' => [
                    'title' => 'Teriyaki Marinade',
                    'meta_keyword' => ['Cooking', 'Sauce'],
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Teriyaki', 'Marinade'],
                'image_path' => 'food/sauces_&_pickles/cooking_sauce',
            ],
            [
                'info' => [
                    'name' => 'Home Menu Sesame Sauce',
                    'category' => 13,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 125,
                    'selling_price' => 138,
                    'variation_price' => 138,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'seo' => [
                    'title' => 'Home Menu Sesame Sauce',
                    'meta_keyword' => ['Cooking', 'Sauce'],
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Home Menu', 'Sesame Sauce'],
                'image_path' => 'food/sauces_&_pickles/cooking_sauce',
            ],
            [
                'info' => [
                    'name' => 'Moroccan Fish Cooking Sauce',
                    'category' => 13,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 130,
                    'selling_price' => 140,
                    'variation_price' => 140,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(16)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(16)->endOfDay(),
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'seo' => [
                    'title' => 'Moroccan Fish Cooking Sauce',
                    'meta_keyword' => ['Cooking', 'Sauce'],
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Moroccan Fish', 'Cooking Sauce'],
                'image_path' => 'food/sauces_&_pickles/cooking_sauce',
            ],
            [
                'info' => [
                    'name' => 'Thai Curry Stir Fry Sauce',
                    'category' => 13,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 122,
                    'selling_price' => 144,
                    'variation_price' => 144,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'seo' => [
                    'title' => 'Thai Curry Stir Fry Sauce',
                    'meta_keyword' => ['Cooking', 'Sauce'],
                    'description' => "<p>Tagine means any meal in one pot, cooked as a stew and served in the traditional clay tagine. It's a dish with extremely tender, fall off the bone meat or perfectly stewed vegetables sinking in the rich and thick sauce which is made with the addition of herbs, spices and dried fruits. A modern brand to complement any kitchen. Mina is the essence of culinary Morocco, where culture is passed down through generations via stories and recipes.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Thai Curry', 'Stir Fry Sauce'],
                'image_path' => 'food/sauces_&_pickles/cooking_sauce',
            ],

            // Food ->  Sauces & Pickles -> Other Table Sauce

            [
                'info' => [
                    'name' => 'Secret Sauce for Burgers',
                    'category' => 14,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 124,
                    'selling_price' => 146,
                    'variation_price' => 146,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(16)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(16)->endOfDay(),
                    'description' => "<p>Great Value Secret Sauce for Burgers &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'seo' => [
                    'title' => 'Secret Sauce for Burgers',
                    'meta_keyword' => ['Other', 'Table Sauce'],
                    'description' => "<p>Great Value Secret Sauce for Burgers &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => [' Secret Sauce', 'Burgers'],
                'image_path' => 'food/sauces_&_pickles/other_table_sauce',
            ],
            [
                'info' => [
                    'name' => 'Alfredo Pasta Sauce',
                    'category' => 14,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 126,
                    'selling_price' => 148,
                    'variation_price' => 148,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Great Value Alfredo Pasta Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'seo' => [
                    'title' => 'Alfredo Pasta Sauce',
                    'meta_keyword' => ['Other', 'Table Sauce'],
                    'description' => "<p>Great Value Alfredo Pasta Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Alfredo', 'Burgers Pasta Sauce'],
                'image_path' => 'food/sauces_&_pickles/other_table_sauce',
            ],
            [
                'info' => [
                    'name' => 'Gluten Free Fish Sauce',
                    'category' => 14,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 128,
                    'selling_price' => 152,
                    'variation_price' => 152,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(17)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(17)->endOfDay(),
                    'description' => "<p>Great Value Gluten Free Fish Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'seo' => [
                    'title' => 'Gluten Free Fish Sauce',
                    'meta_keyword' => ['Other', 'Table Sauce'],
                    'description' => "<p>Great Value Gluten Free Fish Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Gluten Free', 'Fish Sauce'],
                'image_path' => 'food/sauces_&_pickles/other_table_sauce',
            ],
            [
                'info' => [
                    'name' => 'Mild Red Enchilada Sauce',
                    'category' => 14,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 130,
                    'selling_price' => 154,
                    'variation_price' => 154,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(17)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(17)->endOfDay(),
                    'description' => "<p>Great Value Mild Red Enchilada Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'seo' => [
                    'title' => ' Mild Red Enchilada Sauce',
                    'meta_keyword' => ['Other', 'Table Sauce'],
                    'description' => "<p>Great Value  Mild Red Enchilada Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => [' Mild Red', 'Enchilada Sauce'],
                'image_path' => 'food/sauces_&_pickles/other_table_sauce',
            ],
            [
                'info' => [
                    'name' => 'Mexican Enchilada Sauce',
                    'category' => 14,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 140,
                    'selling_price' => 174,
                    'variation_price' => 174,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(18)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(18)->endOfDay(),
                    'description' => "<p>Great Value  Mexican Enchilada Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'seo' => [
                    'title' => 'Mexican Enchilada Sauce',
                    'meta_keyword' => ['Other', 'Table Sauce'],
                    'description' => "<p>Great Value   Mexican Enchilada Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Mexican', 'Enchilada Sauce'],
                'image_path' => 'food/sauces_&_pickles/other_table_sauce',
            ],
            [
                'info' => [
                    'name' => 'Nacho Cheese Sauce',
                    'category' => 14,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 150,
                    'selling_price' => 184,
                    'variation_price' => 184,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(18)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(18)->endOfDay(),
                    'description' => "<p>Great Value  Nacho Cheese Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'seo' => [
                    'title' => 'Nacho Cheese Sauce',
                    'meta_keyword' => ['Other', 'Table Sauce'],
                    'description' => "<p>Great Value   Nacho Cheese Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Nacho', 'Cheese Sauce'],
                'image_path' => 'food/sauces_&_pickles/other_table_sauce',
            ],
            [
                'info' => [
                    'name' => 'Sweet & Smoky BBQ Sauce',
                    'category' => 14,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 150,
                    'selling_price' => 184,
                    'variation_price' => 184,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(19)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(19)->endOfDay(),
                    'description' => "<p>Great Value  Sweet & Smoky BBQ Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'seo' => [
                    'title' => 'Sweet & Smoky BBQ Sauce',
                    'meta_keyword' => ['Other', 'Table Sauce'],
                    'description' => "<p>Great Value   Sweet & Smoky BBQ Sauce &amp; Dipping is the added touch your meals have been missing. This versatile condiment will bring zesty, sweet flavor to a wide assortment of family favorites including burgers, sandwiches, fries, chicken strips, fried pickles, tater tots, and more! This sauce comes in a bottle that is easy to squeeze for added convenience. Use it as a dip for grilled chicken and seafood, or keep a bottle of secret sauce on the table at your next cookout.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Sweet & Smoky', 'BBQ Sauce'],
                'image_path' => 'food/sauces_&_pickles/other_table_sauce',
            ],

            // Chocolates
            [
                'info' => [
                    'name' => 'Milk Chocolate Hazelnut',
                    'category' => 16,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 9,
                    'selling_price' => 15,
                    'variation_price' => 15,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Milk Chocolate Hazelnut',
                    'meta_keyword' => ['Chocolates'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Chocolates'],
                'image_path' => 'food/candy_&_chocolates/chocolates',
            ],
            [
                'info' => [
                    'name' => 'Milk Chocolate Candy',
                    'category' => 16,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 8,
                    'selling_price' => 16,
                    'variation_price' => 16,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Milk Chocolate Candy',
                    'meta_keyword' => ['Chocolates'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Chocolates'],
                'image_path' => 'food/candy_&_chocolates/chocolates',
            ],
            [
                'info' => [
                    'name' => 'Chocolate Truffles Gift Box',
                    'category' => 16,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 11,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Chocolate Truffles Gift Box',
                    'meta_keyword' => ['Chocolates'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Chocolates'],
                'image_path' => 'food/candy_&_chocolates/chocolates',
            ],
            [
                'info' => [
                    'name' => 'Hazelnut Milk & Dark Chocolate',
                    'category' => 16,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 13,
                    'selling_price' => 23,
                    'variation_price' => 23,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Hazelnut Milk & Dark Chocolate',
                    'meta_keyword' => ['Chocolates'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Chocolates'],
                'image_path' => 'food/candy_&_chocolates/chocolates',
            ],
            [
                'info' => [
                    'name' => 'White Creme Candy',
                    'category' => 16,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 23,
                    'selling_price' => 32,
                    'variation_price' => 32,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'White Creme Candy',
                    'meta_keyword' => ['Chocolates'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Chocolates'],
                'image_path' => 'food/candy_&_chocolates/chocolates',
            ],
            [
                'info' => [
                    'name' => 'Chocolate Candy Truffles',
                    'category' => 16,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 13,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(19)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(19)->endOfDay(),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Chocolate Candy Truffles',
                    'meta_keyword' => ['Chocolates'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Chocolates'],
                'image_path' => 'food/candy_&_chocolates/chocolates',
            ],
            [
                'info' => [
                    'name' => 'Premium Chocolate Bar',
                    'category' => 16,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 11,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Premium Chocolate Bar',
                    'meta_keyword' => ['Chocolates'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Chocolates'],
                'image_path' => 'food/candy_&_chocolates/chocolates',
            ],
            [
                'info' => [
                    'name' => 'Milk Silky Chocolate Candy',
                    'category' => 16,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 23,
                    'selling_price' => 28,
                    'variation_price' => 28,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Milk Silky Chocolate Candy',
                    'meta_keyword' => ['Chocolates'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Chocolates'],
                'image_path' => 'food/candy_&_chocolates/chocolates',
            ],
            [
                'info' => [
                    'name' => 'Milk Chocolate Candy Bars',
                    'category' => 16,
                    'brand' => 1,
                    'unit_id' => 6,
                    'buying_price' => 25,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Milk Chocolate Candy Bars',
                    'meta_keyword' => ['Chocolates'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Chocolates'],
                'image_path' => 'food/candy_&_chocolates/chocolates',
            ],

            // Wafers
            [
                'info' => [
                    'name' => 'Peanut Butter Wafer Bar',
                    'category' => 17,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 12,
                    'selling_price' => 22,
                    'variation_price' => 22,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Enjoy a sweet and salty snack wherever you go with these crunchy Great Value Peanut Butter Wafer Bars. These sweet and satisfying bars are a good accompaniment to coffee, or can be enjoyed on their own. The pack contains six two-packs, each of which is individually wrapped. Satisfy those between-the-meal cravings or have a quick snack with these Great Value Peanut Butter Wafer Bars.</p>",
                ],
                'seo' => [
                    'title' => 'Peanut Butter Wafer Bar',
                    'meta_keyword' => ['Wafers'],
                    'description' => "<p>Enjoy a sweet and salty snack wherever you go with these crunchy Great Value Peanut Butter Wafer Bars. These sweet and satisfying bars are a good accompaniment to coffee, or can be enjoyed on their own. The pack contains six two-packs, each of which is individually wrapped. Satisfy those between-the-meal cravings or have a quick snack with these Great Value Peanut Butter Wafer Bars.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Wafers'],
                'image_path' => 'food/candy_&_chocolates/wafers',
            ],
            [
                'info' => [
                    'name' => 'NUTTY BUDDY ® wafers bar',
                    'category' => 17,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'NUTTY BUDDY ® wafers bar',
                    'meta_keyword' => ['Wafers'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Wafers'],
                'image_path' => 'food/candy_&_chocolates/wafers',
            ],
            [
                'info' => [
                    'name' => 'Crispy Creamy Wafer Bar',
                    'category' => 17,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 43,
                    'selling_price' => 48,
                    'variation_price' => 48,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Crispy Creamy Wafer Bar',
                    'meta_keyword' => ['Wafers'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Wafers'],
                'image_path' => 'food/candy_&_chocolates/wafers',
            ],

            [
                'info' => [
                    'name' => 'KITKAT Crisp Wafers',
                    'category' => 17,
                    'brand' => 1,
                    'unit_id' => 1,
                    'buying_price' => 34,
                    'selling_price' => 40,
                    'variation_price' => 40,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(20)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(20)->endOfDay(),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'KITKAT Crisp Wafers',
                    'meta_keyword' => ['Wafers'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Wafers'],
                'image_path' => 'food/candy_&_chocolates/wafers',
            ],
            [
                'info' => [
                    'name' => 'Cream-Filled Wafer',
                    'category' => 17,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 45,
                    'selling_price' => 55,
                    'variation_price' => 55,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Cream-Filled Wafer',
                    'meta_keyword' => ['Wafers'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Wafers'],
                'image_path' => 'food/candy_&_chocolates/wafers',
            ],
            [
                'info' => [
                    'name' => 'Quadratini Wafer Cookies',
                    'category' => 17,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 20,
                    'variation_price' => 20,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Quadratini Wafer Cookies',
                    'meta_keyword' => ['Wafers'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Wafers'],
                'image_path' => 'food/candy_&_chocolates/wafers',
            ],

            [
                'info' => [
                    'name' => 'Bauducco Wafers',
                    'category' => 17,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 4,
                    'selling_price' => 9,
                    'variation_price' => 9,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Bauducco Wafers',
                    'meta_keyword' => ['Wafers'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Wafers'],
                'image_path' => 'food/candy_&_chocolates/wafers',
            ],

            [
                'info' => [
                    'name' => 'Nilla Wafers Cookies',
                    'category' => 17,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 5,
                    'selling_price' => 10,
                    'variation_price' => 10,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(20)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(20)->endOfDay(),
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'seo' => [
                    'title' => 'Nilla Wafers Cookies',
                    'meta_keyword' => ['Wafers'],
                    'description' => "<p>Ferrero Rocher's milk chocolate gift box offers a unique taste experience of contrasting layers: a whole crunchy hazelnut in the heart and a delicious, creamy hazelnut filling surrounded with milk chocolate, crispy wafers and gently roasted hazelnut pieces. And thanks to its signature golden wrapper, Ferrero Rocher is even more unique and special. The iconic original. Celebrate the moment with Ferrero Rocher.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Wafers'],
                'image_path' => 'food/candy_&_chocolates/wafers',
            ],

            // Candies

            [
                'info' => [
                    'name' => 'Fruit Chews Chewy Candy',
                    'category' => 18,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 8,
                    'selling_price' => 15,
                    'variation_price' => 15,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'seo' => [
                    'title' => 'Fruit Chews Chewy Candy',
                    'meta_keyword' => ['Candies'],
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Candies'],
                'image_path' => 'food/candy_&_chocolates/candies',
            ],

            [
                'info' => [
                    'name' => 'Fruit Flavored Hard Candy',
                    'category' => 18,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 18,
                    'selling_price' => 31,
                    'variation_price' => 31,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'seo' => [
                    'title' => 'Fruit Flavored Hard Candy',
                    'meta_keyword' => ['Candies'],
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Candies'],
                'image_path' => 'food/candy_&_chocolates/candies',
            ],

            [
                'info' => [
                    'name' => 'Assorted Fruit Mini Bars',
                    'category' => 18,
                    'brand' => 4,
                    'unit_id' => 1,
                    'buying_price' => 10,
                    'selling_price' => 32,
                    'variation_price' => 32,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(21)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(21)->endOfDay(),
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",

                ],
                'seo' => [
                    'title' => 'Assorted Fruit Mini Bars',
                    'meta_keyword' => ['Candies'],
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Candies'],
                'image_path' => 'food/candy_&_chocolates/candies',
            ],

            [
                'info' => [
                    'name' => 'Strawberry Soft & Chewy Candy',
                    'category' => 18,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 12,
                    'selling_price' => 24,
                    'variation_price' => 24,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'seo' => [
                    'title' => 'Strawberry Soft & Chewy Candy',
                    'meta_keyword' => ['Candies'],
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Candies'],
                'image_path' => 'food/candy_&_chocolates/candies',
            ],

            [
                'info' => [
                    'name' => 'Skittles Sour Candy',
                    'category' => 18,
                    'brand' => 6,
                    'unit_id' => 6,
                    'buying_price' => 13,
                    'selling_price' => 26,
                    'variation_price' => 26,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 7,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'seo' => [
                    'title' => 'Skittles Sour Candy',
                    'meta_keyword' => ['Candies'],
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Candies'],
                'image_path' => 'food/candy_&_chocolates/candies',
            ],

            [
                'info' => [
                    'name' => 'Peach Rings Chewy Candy',
                    'category' => 18,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'seo' => [
                    'title' => 'Peach Rings Chewy Candy',
                    'meta_keyword' => ['Candies'],
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Candies'],
                'image_path' => 'food/candy_&_chocolates/candies',
            ],
            [
                'info' => [
                    'name' => 'Chocolate Snack Size Candy',
                    'category' => 18,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 23,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'seo' => [
                    'title' => 'Chocolate Snack Size Candy',
                    'meta_keyword' => ['Candies'],
                    'description' => "<p>Like a mixtape of your favorite songs, STARBURST FaveREDS Chewy Candy is a mix of your favorite juicy red flavors all in one place. Enjoy an exclusive mix of strawberry, fruit punch, watermelon and cherry flavors in a resealable bag. STARBURST Gummy Candy are unexplainably juicy, deliciously fruity and amazingly chewy. Great for birthday parties and baby showers, this bag of red and pink candy is also a perfect piñata candy.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Candies'],
                'image_path' => 'food/candy_&_chocolates/candies',
            ],

            // Gums & Mints
            [
                'info' => [
                    'name' => 'Trident Sugar Free Gum',
                    'category' => 19,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 23,
                    'variation_price' => 23,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'seo' => [
                    'title' => 'Trident Sugar Free Gum',
                    'meta_keyword' => ['Gums', 'Mints'],
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Gums', 'Mints'],
                'image_path' => 'food/candy_&_chocolates/gums_&_mint',
            ],
            [
                'info' => [
                    'name' => 'Arctic Grape Sugar Free Gum',
                    'category' => 19,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 22,
                    'selling_price' => 32,
                    'variation_price' => 32,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(21)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(21)->endOfDay(),
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'seo' => [
                    'title' => 'Arctic Grape Sugar Free Gum',
                    'meta_keyword' => ['Gums', 'Mints'],
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Gums', 'Mints'],
                'image_path' => 'food/candy_&_chocolates/gums_&_mint',
            ],

            [
                'info' => [
                    'name' => 'Pink Lemonade Gum',
                    'category' => 19,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'seo' => [
                    'title' => 'Pink Lemonade Gum',
                    'meta_keyword' => ['Gums', 'Mints'],
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Gums', 'Mints'],
                'image_path' => 'food/candy_&_chocolates/gums_&_mint',
            ],
            [
                'info' => [
                    'name' => 'Berry Mix Chewing Gum',
                    'category' => 19,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 26,
                    'selling_price' => 36,
                    'variation_price' => 36,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(22)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(22)->endOfDay(),
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'seo' => [
                    'title' => 'Berry Mix Chewing Gum',
                    'meta_keyword' => ['Gums', 'Mints'],
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Gums', 'Mints'],
                'image_path' => 'food/candy_&_chocolates/gums_&_mint',
            ],
            [
                'info' => [
                    'name' => 'Tic Tac Fruit Adventure Mints',
                    'category' => 19,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 28,
                    'selling_price' => 38,
                    'variation_price' => 38,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'seo' => [
                    'title' => 'Tic Tac Fruit Adventure Mints',
                    'meta_keyword' => ['Gums', 'Mints'],
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Gums', 'Mints'],
                'image_path' => 'food/candy_&_chocolates/gums_&_mint',
            ],
            [
                'info' => [
                    'name' => 'Peppermint Candy Puffs',
                    'category' => 19,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 24,
                    'selling_price' => 32,
                    'variation_price' => 32,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'seo' => [
                    'title' => 'Peppermint Candy Puffs',
                    'meta_keyword' => ['Gums', 'Mints'],
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Gums', 'Mints'],
                'image_path' => 'food/candy_&_chocolates/gums_&_mint',
            ],
            [
                'info' => [
                    'name' => 'Mentos Chewy Mint',
                    'category' => 19,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 23,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 8,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'seo' => [
                    'title' => 'Mentos Chewy Mint',
                    'meta_keyword' => ['Gums', 'Mints'],
                    'description' => "<p>Sugar Free Gum made with Xylitol is a delicious way to freshen breath and protect your teeth. This gum has 30% fewer calories than sugared gum. This gum is sweetened with xylitol, a naturally occurring sugar alcohol. The ADA Council on Scientific Affairs found that chewing Trident sugarless gum for 20 minutes after eating stimulates saliva flow. This helps prevent cavities by reducing plaque acids and strengthening teeth. Bulk gum packs give you plenty to stock your home or office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Gums', 'Mints'],
                'image_path' => 'food/candy_&_chocolates/gums_&_mint',
            ],

            // Beverages
            [
                'info' => [
                    'name' => 'Dr Thunder 2 L',
                    'category' => 21,
                    'brand' => 6,
                    'unit_id' => 1,
                    'buying_price' => 23,
                    'selling_price' => 34,
                    'variation_price' => 34,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => 'Dr Thunder 2 L',
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],
            [
                'info' => [
                    'name' => "Sam's Cola Diet Soda",
                    'category' => 21,
                    'brand' => 1,
                    'unit_id' => 1,
                    'buying_price' => 14,
                    'selling_price' => 26,
                    'variation_price' => 26,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => "Sam's Cola Diet Soda",
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],
            [
                'info' => [
                    'name' => 'Mountain Lightning Soda',
                    'category' => 21,
                    'brand' => 2,
                    'unit_id' => 1,
                    'buying_price' => 26,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => 'Mountain Lightning Soda',
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],

            [
                'info' => [
                    'name' => 'Caffeine-Free Ginger Ale',
                    'category' => 21,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 35,
                    'selling_price' => 48,
                    'variation_price' => 48,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => 'Caffeine-Free Ginger Ale',
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],

            [
                'info' => [
                    'name' => 'Dr Pepper Soda Pop',
                    'category' => 21,
                    'brand' => 4,
                    'unit_id' => 1,
                    'buying_price' => 14,
                    'selling_price' => 34,
                    'variation_price' => 34,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 9,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => 'Dr Pepper Soda Pop',
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],
            [
                'info' => [
                    'name' => 'Sunkist Orange Soda Pop',
                    'category' => 21,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 4,
                    'selling_price' => 12,
                    'variation_price' => 12,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => 'Sunkist Orange Soda Pop',
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],

            [
                'info' => [
                    'name' => 'Sprite Lemon Lime Soda',
                    'category' => 21,
                    'brand' => 6,
                    'unit_id' => 1,
                    'buying_price' => 5,
                    'selling_price' => 13,
                    'variation_price' => 13,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => 'Sprite Lemon Lime Soda',
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],

            [
                'info' => [
                    'name' => 'Cream Soda Pop, 12 fl oz',
                    'category' => 21,
                    'brand' => 2,
                    'unit_id' => 1,
                    'buying_price' => 14,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => 'Cream Soda Pop, 12 fl oz',
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],

            [
                'info' => [
                    'name' => 'Twist up Lemon Lime Soda',
                    'category' => 21,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 15,
                    'selling_price' => 29,
                    'variation_price' => 29,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(22)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(22)->endOfDay(),
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => 'Twist up Lemon Lime Soda',
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],

            [
                'info' => [
                    'name' => 'Grapefruit Citrus Mini Soda',
                    'category' => 21,
                    'brand' => 4,
                    'unit_id' => 1,
                    'buying_price' => 20,
                    'selling_price' => 29,
                    'variation_price' => 29,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'seo' => [
                    'title' => 'Grapefruit Citrus Mini Soda',
                    'meta_keyword' => ['Beverages'],
                    'description' => "<p>Enjoy the sweet, distinctive taste of Great Value Dr Thunder Soda. This fizzy, satisfying beverage is perfect to serve at barbecues, family meals, picnics, block parties, and other social events. This flavor-packed soda pairs well with burgers, pizza, grilled chicken, steaks, wings, and many other foods. Serve it chilled and poured over ice to get the most out of this zippy carbonated soda. Try Great Value Dr Thunder Soda and get the bubbly refreshment and zesty flavor you crave.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Beverages'],
                'image_path' => 'food/beverages/soft_drinks',
            ],

            // Tea
            [
                'info' => [
                    'name' => "Milo's Sweet Iced Tea",
                    'category' => 22,
                    'brand' => 6,
                    'unit_id' => 6,
                    'buying_price' => 20,
                    'selling_price' => 29,
                    'variation_price' => 29,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'seo' => [
                    'title' => "Milo's Sweet Iced Tea",
                    'meta_keyword' => ['Tea'],
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Tea'],
                'image_path' => 'food/beverages/tea',
            ],
            [
                'info' => [
                    'name' => "Black Tea Bags, 8 oz",
                    'category' => 22,
                    'brand' => 1,
                    'unit_id' => 6,
                    'buying_price' => 31,
                    'selling_price' => 39,
                    'variation_price' => 39,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'seo' => [
                    'title' => "Black Tea Bags, 8 oz",
                    'meta_keyword' => ['Tea'],
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Tea'],
                'image_path' => 'food/beverages/tea',
            ],
            [
                'info' => [
                    'name' => 'Arizona Green Tea 11.5 Oz',
                    'category' => 22,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 11,
                    'selling_price' => 21,
                    'variation_price' => 21,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'seo' => [
                    'title' => 'Arizona Green Tea 11.5 Oz',
                    'meta_keyword' => ['Tea'],
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Tea'],
                'image_path' => 'food/beverages/tea',
            ],

            [
                'info' => [
                    'name' => 'Lipton Brisk Lemon Iced Tea',
                    'category' => 22,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 22,
                    'selling_price' => 32,
                    'variation_price' => 32,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(23)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(23)->endOfDay(),
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'seo' => [
                    'title' => 'Lipton Brisk Lemon Iced Tea',
                    'meta_keyword' => ['Tea'],
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Tea'],
                'image_path' => 'food/beverages/tea',
            ],

            [
                'info' => [
                    'name' => 'Real Brewed Tea Zero Sugar',
                    'category' => 22,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 31,
                    'selling_price' => 43,
                    'variation_price' => 43,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'seo' => [
                    'title' => 'Real Brewed Tea Zero Sugar',
                    'meta_keyword' => ['Tea'],
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Tea'],
                'image_path' => 'food/beverages/tea',
            ],
            [
                'info' => [
                    'name' => 'Lipton Raspberry White Tea',
                    'category' => 22,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 34,
                    'selling_price' => 44,
                    'variation_price' => 44,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'seo' => [
                    'title' => 'Lipton Raspberry White Tea',
                    'meta_keyword' => ['Tea'],
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Tea'],
                'image_path' => 'food/beverages/tea',
            ],

            [
                'info' => [
                    'name' => 'Sweet Iced Tea & Lemonade',
                    'category' => 22,
                    'brand' => 6,
                    'unit_id' => 6,
                    'buying_price' => 14,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'seo' => [
                    'title' => 'Sweet Iced Tea & Lemonade',
                    'meta_keyword' => ['Tea'],
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Tea'],
                'image_path' => 'food/beverages/tea',
            ],

            [
                'info' => [
                    'name' => 'Real Brewed Tea Unsweetened',
                    'category' => 22,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 6,
                    'selling_price' => 12,
                    'variation_price' => 12,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'seo' => [
                    'title' => 'Real Brewed Tea Unsweetened',
                    'meta_keyword' => ['Tea'],
                    'description' => "<p>Enjoy the soothing aroma and vibrant flavor of Great Value Black Tea Bags. Steep in hot water and serve with lemon for a classic and satisfying combination that you can enjoy morning, noon, or night. Try this black tea over ice or use it to create sun tea during warmer times of the year when you need a refreshing, sugar-free drink. Each container of Great Value Black Tea Bags comes with 100 bags, so you can stay well-stocked both at home and at the office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Tea'],
                'image_path' => 'food/beverages/tea',
            ],

            // Coffee

            [
                'info' => [
                    'name' => 'Classic Roast Ground Coffee',
                    'category' => 23,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 8,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 8,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'seo' => [
                    'title' => 'Classic Roast Ground Coffee',
                    'meta_keyword' => ['Coffee'],
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Coffee'],
                'image_path' => 'food/beverages/coffee',
            ],

            [
                'info' => [
                    'name' => 'Medium Roast Ground Coffee',
                    'category' => 23,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 8,
                    'selling_price' => 15,
                    'variation_price' => 15,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(23)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(23)->endOfDay(),
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'seo' => [
                    'title' => 'Medium Roast Ground Coffee',
                    'meta_keyword' => ['Coffee'],
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Coffee'],
                'image_path' => 'food/beverages/coffee',
            ],

            [
                'info' => [
                    'name' => 'Folgers Roast Ground Coffee',
                    'category' => 23,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 18,
                    'selling_price' => 26,
                    'variation_price' => 26,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'seo' => [
                    'title' => 'Folgers Roast Ground Coffee',
                    'meta_keyword' => ['Coffee'],
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Coffee'],
                'image_path' => 'food/beverages/coffee',
            ],

            [
                'info' => [
                    'name' => 'Original Roast Ground Coffee',
                    'category' => 23,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 23,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(23)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(23)->endOfDay(),
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",

                ],
                'seo' => [
                    'title' => 'Original Roast Ground Coffee',
                    'meta_keyword' => ['Coffee'],
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Coffee'],
                'image_path' => 'food/beverages/coffee',
            ],

            [
                'info' => [
                    'name' => 'Hazelnut Ground Coffee',
                    'category' => 23,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 32,
                    'selling_price' => 43,
                    'variation_price' => 43,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'seo' => [
                    'title' => 'Hazelnut Ground Coffee',
                    'meta_keyword' => ['Coffee'],
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Coffee'],
                'image_path' => 'food/beverages/coffee',
            ],

            [
                'info' => [
                    'name' => 'French Vanilla Ground Coffee',
                    'category' => 23,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 6,
                    'selling_price' => 23,
                    'variation_price' => 23,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'seo' => [
                    'title' => 'French Vanilla Ground Coffee',
                    'meta_keyword' => ['Coffee'],
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Coffee'],
                'image_path' => 'food/beverages/coffee',
            ],

            [
                'info' => [
                    'name' => 'Colombian Dark Roast Coffee',
                    'category' => 23,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 5,
                    'selling_price' => 15,
                    'variation_price' => 15,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'seo' => [
                    'title' => 'Colombian Dark Roast Coffee',
                    'meta_keyword' => ['Coffee'],
                    'description' => "<p>Skip the coffee shop and indulge in a cup of Great Value Classic Roast Medium Ground Coffee. The rich and smooth medium blend is kosher certified and does not contain any allergens. The suggested brewing instructions follow a simple ratio of one tablespoon of coffee per each six-ounce cup, so it's just as easy to make coffee for two people as it is for the whole family. This blend is exceptional as an everyday indulgence and affordable to buy in bulk for the office.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Coffee'],
                'image_path' => 'food/beverages/coffee',
            ],

            // Juice

            [
                'info' => [
                    'name' => 'Fruit Punch Juice Drink',
                    'category' => 24,
                    'brand' => 3,
                    'unit_id' => 4,
                    'buying_price' => 6,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'seo' => [
                    'title' => 'Fruit Punch Juice Drink',
                    'meta_keyword' => ['Juice'],
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Juice'],
                'image_path' => 'food/beverages/juice',
            ],

            [
                'info' => [
                    'name' => 'Sweeteners Apple Juice',
                    'category' => 24,
                    'brand' => 3,
                    'unit_id' => 4,
                    'buying_price' => 23,
                    'selling_price' => 38,
                    'variation_price' => 38,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 8,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'seo' => [
                    'title' => 'Sweeteners Apple Juice',
                    'meta_keyword' => ['Juice'],
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Juice'],
                'image_path' => 'food/beverages/juice',
            ],

            [
                'info' => [
                    'name' => 'Kool Aid Jammers Variety Pack',
                    'category' => 24,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 30,
                    'selling_price' => 40,
                    'variation_price' => 40,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'seo' => [
                    'title' => 'Kool Aid Jammers Variety Pack',
                    'meta_keyword' => ['Juice'],
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Juice'],
                'image_path' => 'food/beverages/juice',
            ],

            [
                'info' => [
                    'name' => 'Hawaiian Punch Fruit Juice',
                    'category' => 24,
                    'brand' => 3,
                    'unit_id' => 4,
                    'buying_price' => 20,
                    'selling_price' => 40,
                    'variation_price' => 40,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(24)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(24)->endOfDay(),
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'seo' => [
                    'title' => 'Hawaiian Punch Fruit Juice',
                    'meta_keyword' => ['Juice'],
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Juice'],
                'image_path' => 'food/beverages/juice',
            ],

            [
                'info' => [
                    'name' => 'Tangy Orange Juice Drink',
                    'category' => 24,
                    'brand' => 3,
                    'unit_id' => 4,
                    'buying_price' => 6,
                    'selling_price' => 16,
                    'variation_price' => 16,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'seo' => [
                    'title' => 'Tangy Orange Juice Drink',
                    'meta_keyword' => ['Juice'],
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Juice'],
                'image_path' => 'food/beverages/juice',
            ],

            [
                'info' => [
                    'name' => 'All Natural Lemonade Juice',
                    'category' => 24,
                    'brand' => 3,
                    'unit_id' => 4,
                    'buying_price' => 17,
                    'selling_price' => 22,
                    'variation_price' => 22,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(24)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(24)->endOfDay(),
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'seo' => [
                    'title' => 'All Natural Lemonade Juice',
                    'meta_keyword' => ['Juice'],
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Juice'],
                'image_path' => 'food/beverages/juice',
            ],

            [
                'info' => [
                    'name' => 'Tropicana Orange Juice',
                    'category' => 24,
                    'brand' => 3,
                    'unit_id' => 4,
                    'buying_price' => 22,
                    'selling_price' => 29,
                    'variation_price' => 29,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'seo' => [
                    'title' => 'Tropicana Orange Juice',
                    'meta_keyword' => ['Juice'],
                    'description' => "<p>From enjoying flavorful fruit punches as a kid to providing your family with delicious fruit drinks as an adult, the Minute Maid brand has been bringing goodness to your family for 75 years. And Minute Maid fruit drinks and juices carry on the tradition of good. All our punches are filled with flavors that tickle your taste buds and have you ready for your next glass. These fruit drinks will satisfy your need for refreshment, and leave you pleased as punch. There is a variety of sizes available to you so you can enjoy the delicious goodness of Minute Maid fruit drinks on-the-go or at home.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Juice'],
                'image_path' => 'food/beverages/juice',
            ],

            // Cleaning Supplies -> Dishwashing Supplies

            [
                'info' => [
                    'name' => 'Scratch-Free Dish Sponge',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(24)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(24)->endOfDay(),
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Scratch-Free Dish Sponge',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Scratch-Free', 'Dish Sponge'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Steel Wool Soap Pads',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Steel Wool Soap Pads',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Steel Wool', 'Soap Pads'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Sponge Daddy Dual-Sided',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(25)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(25)->endOfDay(),
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Sponge Daddy Dual-Sided',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => [' Sponge Daddy', 'Dual-Sided'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Non-Scratch Scrub Sponges',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Non-Scratch Scrub Sponges',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Non-Scratch', 'Scrub Sponges'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'EZ-Squeeze Dishwashing',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(25)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(25)->endOfDay(),
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => ' EZ-Squeeze Dishwashing',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => [' EZ-Squeeze', 'Dishwashing'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'EZ-Squeeze Dish Soap',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'EZ-Squeeze Dish Soap',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => [' EZ-Squeeze', 'Dish Soap'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Ajax Ultra Liquid Dish Soap',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Ajax Ultra Liquid Dish Soap',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Ajax Ultra', 'Liquid Dish Soap'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Powerwash Apple Dish Spray',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Powerwash Apple Dish Spray',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Powerwash Apple', ' Dish Spray'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Liquid Dish Soap',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Liquid Dish Soap',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Liquid', 'Dish Soap'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Dawn Liquid Dish Soap',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => ' Dawn Liquid Dish Soap',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Liquid', 'Dish Soap'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'EZ Squeeze Dish Soap',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'EZ Squeeze Dish Soap',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['EZ Squeeze', 'Dish Soap'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Concentrated Liquid Dish Soap',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(26)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(26)->endOfDay(),
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Concentrated Liquid Dish Soap',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Concentrated Liquid', 'Dish Soap'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Antibacterial Liquid Dish Soap',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Antibacterial Liquid Dish Soap',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Antibacterial', 'Liquid Dish Soap'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],
            [
                'info' => [
                    'name' => 'Liquid Dish Detergent',
                    'category' => 26,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 50,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(27)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(27)->endOfDay(),
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'seo' => [
                    'title' => 'Liquid Dish Detergent',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Dawn dishwashing liquid dish soap can even be used to clean items beyond the kitchen sink. Use Dawn dishwashing liquid to remove grease and grime from external car surfaces and the outer shroud of a gas grill. Dawn dishwashing liquid dish soap is tough on grease, yet gentle.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Liquid', 'Dish Detergent'],
                'image_path' => 'cleaning_supplies/dishwashing_supplies',
            ],

            // Cleaning Supplies -> Laundry
            [
                'info' => [
                    'name' => 'Laundry Stain Remover Powder',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 200,
                    'selling_price' => 300,
                    'variation_price' => 300,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'Laundry Stain Remover Powder',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Laundry Stain', 'Remover Powder'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => 'Gain Liquid Laundry Detergent',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 205,
                    'selling_price' => 310,
                    'variation_price' => 310,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(27)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(27)->endOfDay(),
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'Gain Liquid Laundry Detergent',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Gain Liquid', 'Laundry Detergent'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => 'Oxi Liquid Laundry Detergent',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 150,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'Oxi Liquid Laundry Detergent',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Oxi Liquid ', 'Laundry Detergent'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => 'Purex Liquid Laundry Detergent',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 140,
                    'selling_price' => 190,
                    'variation_price' => 190,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'Purex Liquid Laundry Detergent',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Purex Liquid', 'Laundry Detergent'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => 'Defense Laundry Detergent',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 140,
                    'selling_price' => 190,
                    'variation_price' => 190,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(28)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(28)->endOfDay(),
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'Defense Laundry Detergent',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Defense', 'Laundry Detergent'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => '5-in-1 Laundry Detergent',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 130,
                    'selling_price' => 180,
                    'variation_price' => 180,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => '5-in-1 Laundry Detergent',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [1, 4],
                'tags' => ['5-in-1', 'Laundry Detergent'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => 'Liquid Laundry Detergent',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 120,
                    'selling_price' => 150,
                    'variation_price' => 150,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(28)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(28)->endOfDay(),
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'Liquid Laundry Detergent',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Liquid', 'Laundry Detergent'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => 'OxiClean Clean Meadow',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 120,
                    'selling_price' => 150,
                    'variation_price' => 150,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(29)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(29)->endOfDay(),
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'OxiClean Clean Meadow',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [1, 4],
                'tags' => ['OxiClean', 'Clean Meadow'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => 'Laundry Scent Booster Pacs',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 110,
                    'selling_price' => 140,
                    'variation_price' => 140,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'Laundry Scent Booster Pacs',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Laundry Scent', 'Booster Pacs'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => 'Laundry Detergent Pacs 500gm',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 100,
                    'selling_price' => 120,
                    'variation_price' => 120,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'Laundry Detergent Pacs 500gm',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Laundry', 'Detergent Pacs'],
                'image_path' => 'cleaning_supplies/laundry',
            ],
            [
                'info' => [
                    'name' => 'Laundry Detergent Pacs 1000gm',
                    'category' => 27,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 150,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'seo' => [
                    'title' => 'Laundry Detergent Pacs 1000gm',
                    'meta_keyword' => ['Cleaning', 'Supplies'],
                    'description' => "<p>Harness the power of oxygen to remove tough stains and odors with OxiClean Odor Blasters Versatile Odor and Stain Remover Powder from America’s #1 stain remover additive brand, tackles big and small stains and odors, for laundry and home. This oxygen-powered, chlorine-free, color-safe laundry stain remover and odor remover helps remove stubborn smells and stains from machine-washable clothing, sheets, towels, workout clothes, shoes, team uniforms, and pet bedding, attacking tough odors like musty towels, body odor and sweat so items smell clean and refreshed.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Laundry', 'Detergent Pacs'],
                'image_path' => 'cleaning_supplies/laundry',
            ],

            //Cleaning Supplies -> Toilet Cleaners

            [
                'info' => [
                    'name' => 'Toilet Bowl Cleaners',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 115,
                    'selling_price' => 185,
                    'variation_price' => 185,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(29)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(29)->endOfDay(),
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Toilet Bowl Cleaners',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Toilet Bowl', 'Bowl Cleaners'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Toilet Bowl Cleaner Gel',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 120,
                    'selling_price' => 190,
                    'variation_price' => 190,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Toilet Bowl Cleaner Gel',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [1],
                'tags' => ['Toilet Bowl', 'Cleaner Gel'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Toilet Bowl Cleaner Pods',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 125,
                    'selling_price' => 195,
                    'variation_price' => 195,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(30)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(30)->endOfDay(),
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Toilet Bowl Cleaner Pods',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Toilet Bowl', 'Cleaner Pods'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Toilet Bowl Cleaner Tablet',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 130,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Toilet Bowl Cleaner Tablet',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Toilet Bowl', 'Cleaner Tablet'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Disposable Toilet Bowl Cleaner',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 140,
                    'selling_price' => 205,
                    'variation_price' => 205,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => Carbon::now()->addDays(30)->startOfDay(),
                    'offer_end_date' => Carbon::now()->addDays(30)->endOfDay(),
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Disposable Toilet Bowl Cleaner',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [4],
                'tags' => ['Disposable Toilet', ' Bowl Cleaner'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],
            [
                'info' => [
                    'name' => 'In-The-Bowl Toilet Cleaner',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 140,
                    'selling_price' => 205,
                    'variation_price' => 205,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'In-The-Bowl Toilet Cleaner',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [2],
                'tags' => ['In-The-Bowl', 'Toilet Cleaner'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Ty-D-Bol Toilet Cleaner',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 150,
                    'selling_price' => 210,
                    'variation_price' => 210,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Ty-D-Bol Toilet Cleaner',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [3],
                'tags' => ['Ty-D-Bol', 'Toilet Cleaner'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Gel Toilet Cleaning Stamp',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 160,
                    'selling_price' => 215,
                    'variation_price' => 215,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Gel Toilet Cleaning Stamp',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Gel Toilet', 'Cleaning Stamp'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Foaming Powder for Toilets',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 165,
                    'selling_price' => 220,
                    'variation_price' => 220,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Foaming Powder for Toilets',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Foaming Powder', 'Powder for Toilets'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Gel Toilet Bowl Cleaner',
                    'category' => 28,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 170,
                    'selling_price' => 225,
                    'variation_price' => 225,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Gel Toilet Bowl Cleaner',
                    'meta_keyword' => ['Toilet', 'Cleaners'],
                    'description' => "<p>Make sure that your bathroom is fresh and inviting for family, friends and guests with our Great Value Toilet Bowl Cleaner with Bleach. This strong cling-action gel works to remove tough stains, helping give your toilet bowl a shiny and sparkling appearance that lasts. The bleach provides whitening and brightening action and the original fresh scent removes odors too, so your bathroom will be left looking and smelling as fresh and clean as ever.&nbsp;</p>",
                ],
                'taxes' => [1],
                'tags' => ['Gel Toilet', 'Bowl Cleaner'],
                'image_path' => 'cleaning_supplies/toilet_cleaners',
            ],

            // Cleaning Supplies -> Napkin & Paper Products
            [
                'info' => [
                    'name' => 'Ultra Paper Napkins',
                    'category' => 29,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 200,
                    'selling_price' => 300,
                    'variation_price' => 300,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Ultra Paper Napkins',
                    'meta_keyword' => ['Napkin', 'Paper Products'],
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Ultra', 'Paper Napkins'],
                'image_path' => 'cleaning_supplies/napkin_&_paper_products',
            ],
            [
                'info' => [
                    'name' => 'Extra Absorbent Paper Napkins',
                    'category' => 29,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 210,
                    'selling_price' => 310,
                    'variation_price' => 310,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Extra Absorbent Paper Napkins',
                    'meta_keyword' => ['Napkin', 'Paper Products'],
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Extra Absorbent', 'Paper Napkins'],
                'image_path' => 'cleaning_supplies/napkin_&_paper_products',
            ],
            [
                'info' => [
                    'name' => 'Dinner Paper Napkins',
                    'category' => 29,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 210,
                    'selling_price' => 310,
                    'variation_price' => 310,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Dinner Paper Napkins',
                    'meta_keyword' => ['Napkin', 'Paper Products'],
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Dinner Paper ', 'Napkins'],
                'image_path' => 'cleaning_supplies/napkin_&_paper_products',
            ],
            [
                'info' => [
                    'name' => 'Frontier Fabric Napkin Set',
                    'category' => 29,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 220,
                    'selling_price' => 320,
                    'variation_price' => 320,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Frontier Fabric Napkin Set',
                    'meta_keyword' => ['Napkin', 'Paper Products'],
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Frontier Fabric ', 'Napkin Set'],
                'image_path' => 'cleaning_supplies/napkin_&_paper_products',
            ],
            [
                'info' => [
                    'name' => 'Cloth Napkins Reusable',
                    'category' => 29,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 230,
                    'selling_price' => 330,
                    'variation_price' => 320,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Cloth Napkins Reusable',
                    'meta_keyword' => ['Napkin', 'Paper Products'],
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Cloth Napkins', 'Napkins Reusable'],
                'image_path' => 'cleaning_supplies/napkin_&_paper_products',
            ],
            [
                'info' => [
                    'name' => 'Paper Napkins for Garden Party',
                    'category' => 29,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 240,
                    'selling_price' => 340,
                    'variation_price' => 340,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Paper Napkins for Garden Party',
                    'meta_keyword' => ['Napkin', 'Paper Products'],
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Paper Napkins', ' Garden Party'],
                'image_path' => 'cleaning_supplies/napkin_&_paper_products',
            ],
            [
                'info' => [
                    'name' => 'Eucalyptus Beverage Napkins',
                    'category' => 29,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 240,
                    'selling_price' => 340,
                    'variation_price' => 340,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Eucalyptus Beverage Napkins',
                    'meta_keyword' => ['Napkin', 'Paper Products'],
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Eucalyptus', 'Beverage Napkins'],
                'image_path' => 'cleaning_supplies/napkin_&_paper_products',
            ],
            [
                'info' => [
                    'name' => 'Paper Napkins for Wedding',
                    'category' => 29,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 240,
                    'selling_price' => 340,
                    'variation_price' => 340,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'seo' => [
                    'title' => 'Paper Napkins for Wedding',
                    'meta_keyword' => ['Napkin', 'Paper Products'],
                    'description' => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Paper Napkins', 'Wedding'],
                'image_path' => 'cleaning_supplies/napkin_&_paper_products',
            ],
            [
                'info' => [
                    'name'             => 'Impressions Dinner Napkins',
                    'category'         => 29,
                    'brand'            => null,
                    'unit_id'          => 1,
                    'buying_price'     => 240,
                    'selling_price'    => 340,
                    'variation_price'  => 340,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::NO,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'seo' => [
                    'title'        => 'Impressions Dinner Napkins',
                    'meta_keyword' => ['Napkin', 'Paper Products'],
                    'description'  => "<p>Experience the blend of softness and strength with Great Value Ultra Paper Napkins, elevating every meal to a celebration. Boasting a two-ply construction, they are perfect for tackling any mealtime event with ease. These white napkins, with dimensions of 13-inches by 12.7-inches, feature a chic embossing, making them a perfect choice for both everyday meals and special dining occasions. Each pack is generously filled with 100 premium quality napkins giving you plenty of napkins to go around.&nbsp;</p>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Impressions', 'Dinner Napkins'],
                'image_path' => 'cleaning_supplies/napkin_&_paper_products',
            ],

            // Cleaning Supplies -> Floor & Glass Cleaners

            [
                'info' => [
                    'name' => 'Great Value Glass Cleaner',
                    'category' => 30,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 100,
                    'selling_price' => 150,
                    'variation_price' => 150,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'seo' => [
                    'title' => 'Great Value Glass Cleaner',
                    'meta_keyword' => ['Floor', 'Glass Cleaners'],
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Great Value', 'Glass Cleaner'],
                'image_path' => 'cleaning_supplies/floor_&_glass_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Multi-Surface Floor Cleaner',
                    'category' => 30,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 100,
                    'selling_price' => 150,
                    'variation_price' => 150,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'seo' => [
                    'title' => 'Multi-Surface Floor Cleaner',
                    'meta_keyword' => ['Floor', 'Glass Cleaners'],
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Multi-Surface', ' Floor Cleaner'],
                'image_path' => 'cleaning_supplies/floor_&_glass_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Hardwood Floor Luster',
                    'category' => 30,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 110,
                    'selling_price' => 160,
                    'variation_price' => 160,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'seo' => [
                    'title' => 'Hardwood Floor Luster',
                    'meta_keyword' => ['Floor', 'Glass Cleaners'],
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Hardwood Floor', 'Luster'],
                'image_path' => 'cleaning_supplies/floor_&_glass_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Glass Window Cleaner',
                    'category' => 30,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 120,
                    'selling_price' => 170,
                    'variation_price' => 170,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'seo' => [
                    'title' => 'Glass Window Cleaner',
                    'meta_keyword' => ['Floor', 'Glass Cleaners'],
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Glass Window', 'Cleaner'],
                'image_path' => 'cleaning_supplies/floor_&_glass_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Finished Floor Cleaner',
                    'category' => 30,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 130,
                    'selling_price' => 180,
                    'variation_price' => 180,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'seo' => [
                    'title' => 'Finished Floor Cleaner',
                    'meta_keyword' => ['Floor', 'Glass Cleaners'],
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Finished Floor', 'Cleaner'],
                'image_path' => 'cleaning_supplies/floor_&_glass_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Multi Surface Cleaner',
                    'category' => 30,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 140,
                    'selling_price' => 185,
                    'variation_price' => 185,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'seo' => [
                    'title' => 'Multi Surface Cleaner',
                    'meta_keyword' => ['Floor', 'Glass Cleaners'],
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Multi Surface ', 'Cleaner'],
                'image_path' => 'cleaning_supplies/floor_&_glass_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Vinegar Glass Window Cleaner',
                    'category' => 30,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 140,
                    'selling_price' => 190,
                    'variation_price' => 190,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'seo' => [
                    'title' => 'Vinegar Glass Window Cleaner',
                    'meta_keyword' => ['Floor', 'Glass Cleaners'],
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Vinegar Glass', 'Window Cleaner'],
                'image_path' => 'cleaning_supplies/floor_&_glass_cleaners',
            ],
            [
                'info' => [
                    'name' => 'Multi Surface Cleaner Spray',
                    'category' => 30,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 140,
                    'selling_price' => 195,
                    'variation_price' => 195,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'seo' => [
                    'title' => 'Multi Surface Cleaner Spray',
                    'meta_keyword' => ['Floor', 'Glass Cleaners'],
                    'description' => "<p>Original Glass Cleaner delivers a streak-free shine every time! When cleaning spaces big or small, you can rely on this spray cleaner to leave your glass windows and mirrors clear and sparkling. The 32-ounce spray bottle is so handy, you can use it just about anywhere to quickly clean and shine. This glass cleaner will be your go-to solution around the house when cleaning glass tables, china cabinets, glass cupboards, granite countertops, stainless steel appliances, bathroom mirrors, and shower doors.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Multi Surface', 'Cleaner Spray'],
                'image_path' => 'cleaning_supplies/floor_&_glass_cleaners',
            ],

            // Cleaning Supplies -> Air Fresheners

            [
                'info' => [
                    'name' => 'Aqua Air Freshener Spray',
                    'category' => 31,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 140,
                    'selling_price' => 195,
                    'variation_price' => 195,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'seo' => [
                    'title' => 'Aqua Air Freshener Spray',
                    'meta_keyword' => ['Air', 'Fresheners'],
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Aqua Air', 'Freshener Spray'],
                'image_path' => 'cleaning_supplies/air_fresheners',
            ],
            [
                'info' => [
                    'name' => 'Vanilla Air Freshener Spray',
                    'category' => 31,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 150,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'seo' => [
                    'title' => 'Vanilla Air Freshener Spray',
                    'meta_keyword' => ['Air', 'Fresheners'],
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Vanilla Air', 'Freshener Spray'],
                'image_path' => 'cleaning_supplies/air_fresheners',
            ],
            [
                'info' => [
                    'name' => 'Linen Air Freshener Spray',
                    'category' => 31,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 150,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'seo' => [
                    'title' => 'Linen Air Freshener Spray',
                    'meta_keyword' => ['Air', 'Fresheners'],
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Linen Air', 'Freshener Spray'],
                'image_path' => 'cleaning_supplies/air_fresheners',
            ],
            [
                'info' => [
                    'name' => 'Odor-Fighting Air Freshener',
                    'category' => 31,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 160,
                    'selling_price' => 210,
                    'variation_price' => 210,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'seo' => [
                    'title' => 'Odor-Fighting Air Freshener',
                    'meta_keyword' => ['Air', 'Fresheners'],
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Odor-Fighting', 'Air Freshener'],
                'image_path' => 'cleaning_supplies/air_fresheners',
            ],
            [
                'info' => [
                    'name' => 'Hawaiin Air Freshener Spray',
                    'category' => 31,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 160,
                    'selling_price' => 220,
                    'variation_price' => 220,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'seo' => [
                    'title' => 'Hawaiin Air Freshener Spray',
                    'meta_keyword' => ['Air', 'Fresheners'],
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Hawaiin Air ', 'Freshener Spray'],
                'image_path' => 'cleaning_supplies/air_fresheners',
            ],
            [
                'info' => [
                    'name' => 'Cherry Air Freshener Spray',
                    'category' => 31,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 160,
                    'selling_price' => 230,
                    'variation_price' => 230,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'seo' => [
                    'title' => 'Cherry Air Freshener Spray',
                    'meta_keyword' => ['Air', 'Fresheners'],
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Cherry Air ', 'Freshener Spray'],
                'image_path' => 'cleaning_supplies/air_fresheners',
            ],
            [
                'info' => [
                    'name' => 'Absorbing Citrus Air Freshener',
                    'category' => 31,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 160,
                    'selling_price' => 240,
                    'variation_price' => 240,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'seo' => [
                    'title' => 'Absorbing Citrus Air Freshener',
                    'meta_keyword' => ['Air', 'Fresheners'],
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'taxes' => [1, 4],
                'tags' => ['Absorbing Citrus', 'Freshener Spray'],
                'image_path' => 'cleaning_supplies/air_fresheners',
            ],
            [
                'info' => [
                    'name' => 'Absorbing Lavender Air Freshener',
                    'category' => 31,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 160,
                    'selling_price' => 250,
                    'variation_price' => 250,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'seo' => [
                    'title' => 'Absorbing Lavender Air Freshener',
                    'meta_keyword' => ['Air', 'Fresheners'],
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Absorbing Lavender', 'Freshener Spray'],
                'image_path' => 'cleaning_supplies/air_fresheners',
            ],
            [
                'info' => [
                    'name' => 'Gel Air Freshener',
                    'category' => 31,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 170,
                    'selling_price' => 260,
                    'variation_price' => 260,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'seo' => [
                    'title' => 'Gel Air Freshener',
                    'meta_keyword' => ['Air', 'Fresheners'],
                    'description' => "<p>Turn your house atmosphere into a whole experience with Great Value® Hawaiian Automatic Air Freshener Spray Refill Twin Pack. Compatible with Glade® and Air Wick® dispensers. Each of these air freshener spray refills will permeate your space for up to 60 days (Total of 120 days), full of delightful scent, your friends and family will surely compliment. Great Value® provides you with a wide range of affordable high-quality products spanning categories from grocery to household consumable options.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Gel Air', 'Freshener Spray'],
                'image_path' => 'cleaning_supplies/air_fresheners',
            ],

            // Women’s Soap
            [
                'info' => [
                    'name' => 'Revitalizing body wash',
                    'category' => 34,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 23,
                    'selling_price' => 34,
                    'variation_price' => 34,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'seo' => [
                    'title' => 'Revitalizing body wash',
                    'meta_keyword' => ['Women’s', 'Soap'],
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Women’s', 'Soap'],
                'image_path' => 'personal_care/womens_care/womens_soap',
            ],

            [
                'info' => [
                    'name' => 'Vanilla Gentle Body Wash',
                    'category' => 34,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 23,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'seo' => [
                    'title' => 'Vanilla Gentle Body Wash',
                    'meta_keyword' => ['Women’s', 'Soap'],
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Women’s', 'Soap'],
                'image_path' => 'personal_care/womens_care/womens_soap',
            ],

            [
                'info' => [
                    'name' => 'Cocoa Gentle Body Wash',
                    'category' => 34,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 8,
                    'selling_price' => 20,
                    'variation_price' => 20,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'seo' => [
                    'title' => 'Cocoa Gentle Body Wash',
                    'meta_keyword' => ['Women’s', 'Soap'],
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Women’s', 'Soap'],
                'image_path' => 'personal_care/womens_care/womens_soap',
            ],

            [
                'info' => [
                    'name' => 'Shea Butter Beauty Bar',
                    'category' => 34,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 12,
                    'selling_price' => 240,
                    'variation_price' => 24,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'seo' => [
                    'title' => 'Shea Butter Beauty Bar',
                    'meta_keyword' => ['Women’s', 'Soap'],
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Women’s', 'Soap'],
                'image_path' => 'personal_care/womens_care/womens_soap',
            ],

            [
                'info' => [
                    'name' => 'Outlast Body Wash',
                    'category' => 34,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 14,
                    'selling_price' => 36,
                    'variation_price' => 36,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 9,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'seo' => [
                    'title' => 'Outlast Body Wash',
                    'meta_keyword' => ['Women’s', 'Soap'],
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Women’s', 'Soap'],
                'image_path' => 'personal_care/womens_care/womens_soap',
            ],

            [
                'info' => [
                    'name' => "Dr Teals Body Wash",
                    'category' => 34,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 23,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'seo' => [
                    'title' => "Dr Teals Body Wash",
                    'meta_keyword' => ['Women’s', 'Soap'],
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Women’s', 'Soap'],
                'image_path' => 'personal_care/womens_care/womens_soap',
            ],

            [
                'info' => [
                    'name' => 'Moisture Womens Body Wash',
                    'category' => 34,
                    'brand' => 3,
                    'unit_id' => 1,
                    'buying_price' => 45,
                    'selling_price' => 55,
                    'variation_price' => 55,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 55,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'seo' => [
                    'title' => 'Moisture Womens Body Wash',
                    'meta_keyword' => ['Women’s', 'Soap'],
                    'description' => "<p>I'm no regular body wash, i’m a cool body wash. a revitalizing, watermelon-minty cool body wash, if you will. i’m one in a melon, baby. we both know the ordinary routine can start to feel a little....ordinary. but babe, you're a breath of fresh air and you should feel like it. so take your shower time to the next level with our powerhouse blend of fruit enzymes that will gently exfoliate, deeply cleanse &amp; revitalize your skin.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Women’s', 'Soap'],
                'image_path' => 'personal_care/womens_care/womens_soap',
            ],

            // Serum & Toner
            [
                'info' => [
                    'name' => 'Salicylic Acid Toner + Serum',
                    'category' => 35,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 33,
                    'selling_price' => 44,
                    'variation_price' => 44,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'seo' => [
                    'title' => 'Salicylic Acid Toner + Serum',
                    'meta_keyword' => ['Serum', 'Toner'],
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Serum', 'Toner'],
                'image_path' => 'personal_care/womens_care/serum_&_toner',
            ],
            [
                'info' => [
                    'name' => 'Anti Wrinkle Face Serum',
                    'category' => 35,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 22,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'seo' => [
                    'title' => 'Anti Wrinkle Face Serum',
                    'meta_keyword' => ['Serum', 'Toner'],
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Serum', 'Toner'],
                'image_path' => 'personal_care/womens_care/serum_&_toner',
            ],
            [
                'info' => [
                    'name' => 'Non Greasy Skin Care Toner',
                    'category' => 35,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 11,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'seo' => [
                    'title' => 'Non Greasy Skin Care Toner',
                    'meta_keyword' => ['Serum', 'Toner'],
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Serum', 'Toner'],
                'image_path' => 'personal_care/womens_care/serum_&_toner',
            ],
            [
                'info' => [
                    'name' => 'Propolis Serum for Skin',
                    'category' => 35,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 8,
                    'selling_price' => 18,
                    'variation_price' => 18,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'seo' => [
                    'title' => 'Propolis Serum for Skin',
                    'meta_keyword' => ['Serum', 'Toner'],
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Serum', 'Toner'],
                'image_path' => 'personal_care/womens_care/serum_&_toner',
            ],

            [
                'info' => [
                    'name' => 'Moisturizing Repair Skin Care',
                    'category' => 35,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 12,
                    'selling_price' => 23,
                    'variation_price' => 23,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'seo' => [
                    'title' => 'Moisturizing Repair Skin Care',
                    'meta_keyword' => ['Serum', 'Toner'],
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Serum', 'Toner'],
                'image_path' => 'personal_care/womens_care/serum_&_toner',
            ],

            [
                'info' => [
                    'name' => 'Lightweight Facial Serum',
                    'category' => 35,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 8,
                    'selling_price' => 10,
                    'variation_price' => 10,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'seo' => [
                    'title' => 'Lightweight Facial Serum',
                    'meta_keyword' => ['Serum', 'Toner'],
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Serum', 'Toner'],
                'image_path' => 'personal_care/womens_care/serum_&_toner',
            ],

            [
                'info' => [
                    'name' => 'Moisturizer Peptide Serum',
                    'category' => 35,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 11,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'seo' => [
                    'title' => 'Moisturizer Peptide Serum',
                    'meta_keyword' => ['Serum', 'Toner'],
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Serum', 'Toner'],
                'image_path' => 'personal_care/womens_care/serum_&_toner',
            ],
            [
                'info' => [
                    'name' => 'Vitamin C Face Serum',
                    'category' => 35,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 8,
                    'selling_price' => 14,
                    'variation_price' => 14,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'seo' => [
                    'title' => 'Vitamin C Face Serum',
                    'meta_keyword' => ['Serum', 'Toner'],
                    'description' => "<p>A fully nutritious essence that contains 63% black bee propolis extract, 10% royal jelly extract, and 10% black honey extract to build a firm barrier for radiant and moist skin. Honey : Since ancient times, honey has been considered a rare delicacy with medicinal properties in both Eastern and Western medicine. It's a natural beauty remedy with anti-aging, moisturizing, and antiseptic properties.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Serum', 'Toner'],
                'image_path' => 'personal_care/womens_care/serum_&_toner',
            ],

            // Shampoo & Conditioner
            [
                'info' => [
                    'name' => 'Blends Shampoo & Conditioner',
                    'category' => 36,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 8,
                    'selling_price' => 15,
                    'variation_price' => 15,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'seo' => [
                    'title' => 'Blends Shampoo & Conditioner',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/womens_care/shampoo_&_conditioner',
            ],

            [
                'info' => [
                    'name' => 'Nourishing Shampoo and Conditioner',
                    'category' => 36,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 12,
                    'selling_price' => 24,
                    'variation_price' => 24,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'seo' => [
                    'title' => 'Nourishing Shampoo and Conditioner',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/womens_care/shampoo_&_conditioner',
            ],

            [
                'info' => [
                    'name' => 'Moroccan Oil Infusion Shampoo',
                    'category' => 36,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 9,
                    'selling_price' => 18,
                    'variation_price' => 18,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 20,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'seo' => [
                    'title' => 'Moroccan Oil Infusion Shampoo',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/womens_care/shampoo_&_conditioner',
            ],
            [
                'info' => [
                    'name' => 'Elvive Moisturizing Shampoo',
                    'category' => 36,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 19,
                    'selling_price' => 29,
                    'variation_price' => 29,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 50,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'seo' => [
                    'title' => 'Elvive Moisturizing Shampoo',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/womens_care/shampoo_&_conditioner',
            ],
            [
                'info' => [
                    'name' => 'Invigorating Shampoo & Conditioner',
                    'category' => 36,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 9,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'seo' => [
                    'title' => 'Invigorating Shampoo & Conditioner',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/womens_care/shampoo_&_conditioner',
            ],

            [
                'info' => [
                    'name' => 'Sleek & Shine Shampoo',
                    'category' => 36,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 8,
                    'selling_price' => 18,
                    'variation_price' => 18,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'seo' => [
                    'title' => 'Sleek & Shine Shampoo',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/womens_care/shampoo_&_conditioner',
            ],

            [
                'info' => [
                    'name' => 'Moisture Nourishing Shampoo',
                    'category' => 36,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 10,
                    'selling_price' => 20,
                    'variation_price' => 20,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'seo' => [
                    'title' => 'Moisture Nourishing Shampoo',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Fructis Grow Strong Shampoo and Conditioner are infused with Apple Extract and Ceramide for stronger, healthier hair. Get up to 3x less breakage with system of shampoo and conditioner. COMMITED TO MAKING GARNIER A GREENER BEAUTY BRAND: As a leading global beauty brand, we aspire to create a positive impact by paving the way towards more and more sustainable beauty that’s accessible to all of us.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/womens_care/shampoo_&_conditioner',
            ],

            // Female Moisturizer

            [
                'info' => [
                    'name' => 'Night Cream Facial Moisturizer',
                    'category' => 37,
                    'brand' => 1,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'seo' => [
                    'title' => 'Night Cream Facial Moisturizer',
                    'meta_keyword' => ['Female', 'Moisturizer'],
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Female', 'Moisturizer'],
                'image_path' => 'personal_care/womens_care/female_moisturizer',
            ],
            [
                'info' => [
                    'name' => 'Anti Aging Moisturizer',
                    'category' => 37,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 20,
                    'selling_price' => 30,
                    'variation_price' => 30,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'seo' => [
                    'title' => 'Anti Aging Moisturizer',
                    'meta_keyword' => ['Female', 'Moisturizer'],
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Female', 'Moisturizer'],
                'image_path' => 'personal_care/womens_care/female_moisturizer',
            ],
            [
                'info' => [
                    'name' => 'Facial Moisturizer for Sensitive Skin',
                    'category' => 37,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 20,
                    'selling_price' => 30,
                    'variation_price' => 30,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'seo' => [
                    'title' => 'Facial Moisturizer for Sensitive Skin',
                    'meta_keyword' => ['Female', 'Moisturizer'],
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Female', 'Moisturizer'],
                'image_path' => 'personal_care/womens_care/female_moisturizer',
            ],
            [
                'info' => [
                    'name' => 'Intimate Vaginal Moisturizer',
                    'category' => 37,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 12,
                    'selling_price' => 18,
                    'variation_price' => 18,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'seo' => [
                    'title' => 'Intimate Vaginal Moisturizer',
                    'meta_keyword' => ['Female', 'Moisturizer'],
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Female', 'Moisturizer'],
                'image_path' => 'personal_care/womens_care/female_moisturizer',
            ],
            [
                'info' => [
                    'name' => 'Vitamin C & Collagen Moisturizer',
                    'category' => 37,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 10,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'seo' => [
                    'title' => 'Vitamin C & Collagen Moisturizer',
                    'meta_keyword' => ['Female', 'Moisturizer'],
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Female', 'Moisturizer'],
                'image_path' => 'personal_care/womens_care/female_moisturizer',
            ],
            [
                'info' => [
                    'name' => 'Capebale Moisturizing Hydrating',
                    'category' => 37,
                    'brand' => 6,
                    'unit_id' => 6,
                    'buying_price' => 22,
                    'selling_price' => 28,
                    'variation_price' => 28,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'seo' => [
                    'title' => 'Capebale Moisturizing Hydrating',
                    'meta_keyword' => ['Female', 'Moisturizer'],
                    'description' => "<p>Moisturize to restore skin’s hydration and reduce the appearance of fine lines and wrinkles with Olay Skincare Firming Night Cream Facial Moisturizer, 1.9 fl oz. Its deeply hydrating formula delivers up to 48 hours of long-lasting moisture that renews skin while you sleep. This non-greasy and rich overnight face moisturizer works to firm all skin types – dry, normal, combination and oily – without clogging pores, so you can wake up to smoother, softer and more supple skin in the morning.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Female', 'Moisturizer'],
                'image_path' => 'personal_care/womens_care/female_moisturizer',
            ],

            // Women’s Perfume
            [
                'info' => [
                    'name' => 'Daisy Eau So Fresh',
                    'category' => 38,
                    'brand' => 6,
                    'unit_id' => 6,
                    'buying_price' => 18,
                    'selling_price' => 28,
                    'variation_price' => 28,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Daisy Eau So Fresh',
                    'meta_keyword' => ["Women’s", 'Perfume'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ["Women’s", 'Perfume'],
                'image_path' => 'personal_care/womens_care/womens_perfume',
            ],
            [
                'info' => [
                    'name' => 'Dylan Blue Eau De Perfume',
                    'category' => 38,
                    'brand' => 1,
                    'unit_id' => 6,
                    'buying_price' => 14,
                    'selling_price' => 26,
                    'variation_price' => 26,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Dylan Blue Eau De Perfume',
                    'meta_keyword' => ["Women’s", 'Perfume'],
                    'description' => "<p><p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ["Women’s", 'Perfume'],
                'image_path' => 'personal_care/womens_care/womens_perfume',
            ],
            [
                'info' => [
                    'name' => 'Guess Girl Eau De',
                    'category' => 38,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 8,
                    'selling_price' => 18,
                    'variation_price' => 18,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Guess Girl Eau De',
                    'meta_keyword' => ["Women’s", 'Perfume'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ["Women’s", 'Perfume'],
                'image_path' => 'personal_care/womens_care/womens_perfume',
            ],

            [
                'info' => [
                    'name' => 'CLUB DE NUIT By STERLING',
                    'category' => 38,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 22,
                    'selling_price' => 32,
                    'variation_price' => 32,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'CLUB DE NUIT By STERLING',
                    'meta_keyword' => ["Women’s", 'Perfume'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [4],
                'tags' => ["Women’s", 'Perfume'],
                'image_path' => 'personal_care/womens_care/womens_perfume',
            ],

            [
                'info' => [
                    'name' => 'NovoGlow Eau de Perfume',
                    'category' => 38,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 33,
                    'selling_price' => 43,
                    'variation_price' => 43,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'NovoGlow Eau de Perfume',
                    'meta_keyword' => ["Women’s", 'Perfume'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ["Women’s", 'Perfume'],
                'image_path' => 'personal_care/womens_care/womens_perfume',
            ],
            [
                'info' => [
                    'name' => 'Viva La Juicy Rose Eau de Parfum',
                    'category' => 38,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 6,
                    'selling_price' => 18,
                    'variation_price' => 18,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Viva La Juicy Rose Eau de Parfum',
                    'meta_keyword' => ["Women’s", 'Perfume'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ["Women’s", 'Perfume'],
                'image_path' => 'personal_care/womens_care/womens_perfume',
            ],
            [
                'info' => [
                    'name' => 'Cool Water by Davidoff Eau De',
                    'category' => 38,
                    'brand' => 6,
                    'unit_id' => 6,
                    'buying_price' => 9,
                    'selling_price' => 16,
                    'variation_price' => 16,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'seo' => [
                    'title' => 'Cool Water by Davidoff Eau De',
                    'meta_keyword' => ["Women’s", 'Perfume'],
                    'description' => "<p>Improves the metabolism, prevents cancer, improves skin, it helps manage weight, controls diabetes, reduces inflammation. It helps regulate sleep.</p><p>Nutritional facts: Calories, Fat, Sodium, Potassium, Carbohydrate, Protein, Calcium, Iron, Vitamin-C, Vitamin B-6, Magnesium.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ["Women’s", 'Perfume'],
                'image_path' => 'personal_care/womens_care/womens_perfume',
            ],

            // Men’s Soap

            [
                'info' => [
                    'name' => 'Dove Men+Care Body',
                    'category' => 40,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 23,
                    'variation_price' => 23,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'seo' => [
                    'title' => 'Dove Men+Care Body',
                    'meta_keyword' => ['Men’s', 'Soap'],
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Soap'],
                'image_path' => 'personal_care/mens_care/mens_soap',
            ],
            [
                'info' => [
                    'name' => 'Face & Shaving Bar Soap',
                    'category' => 40,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 22,
                    'selling_price' => 32,
                    'variation_price' => 32,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'seo' => [
                    'title' => 'Face & Shaving Bar Soap',
                    'meta_keyword' => ['Men’s', 'Soap'],
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Soap'],
                'image_path' => 'personal_care/mens_care/mens_soap',
            ],

            [
                'info' => [
                    'name' => 'Big Ass Brick of Soap',
                    'category' => 40,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'seo' => [
                    'title' => 'Big Ass Brick of Soap',
                    'meta_keyword' => ['Men’s', 'Soap'],
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Soap'],
                'image_path' => 'personal_care/mens_care/mens_soap',
            ],
            [
                'info' => [
                    'name' => 'Men Body & Face Wash',
                    'category' => 40,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 26,
                    'selling_price' => 36,
                    'variation_price' => 36,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'seo' => [
                    'title' => 'Men Body & Face Wash',
                    'meta_keyword' => ['Men’s', 'Soap'],
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Soap'],
                'image_path' => 'personal_care/mens_care/mens_soap',
            ],
            [
                'info' => [
                    'name' => 'Man Jack Sandalwood',
                    'category' => 40,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 28,
                    'selling_price' => 38,
                    'variation_price' => 38,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'seo' => [
                    'title' => 'Man Jack Sandalwood',
                    'meta_keyword' => ['Men’s', 'Soap'],
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Soap'],
                'image_path' => 'personal_care/mens_care/mens_soap',
            ],
            [
                'info' => [
                    'name' => 'Hydration Body Wash',
                    'category' => 40,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 24,
                    'selling_price' => 32,
                    'variation_price' => 32,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'seo' => [
                    'title' => 'Hydration Body Wash',
                    'meta_keyword' => ['Men’s', 'Soap'],
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Soap'],
                'image_path' => 'personal_care/mens_care/mens_soap',
            ],
            [
                'info' => [
                    'name' => '5 in 1 Body Wash for Men',
                    'category' => 40,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 23,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 8,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'seo' => [
                    'title' => '5 in 1 Body Wash for Men',
                    'meta_keyword' => ['Men’s', 'Soap'],
                    'description' => "<p>Looking for a bar that leaves skin feeling refreshed, hydrated, and invigorated? Dove Men+Care Extra Fresh Body and Face Bar delivers a deep, refreshing clean and hydration. Unlike ordinary men's bar soap or body soap that can dry out skin, this bar is formulated with more moisture to help maintain skin moisture and hydration levels, leaving it feeling healthy, smooth, and comfortable.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Soap'],
                'image_path' => 'personal_care/mens_care/mens_soap',
            ],

            // Men’s Perfume
            [
                'info' => [
                    'name' => 'Savage 100 ml 3.4 oz',
                    'category' => 41,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 85,
                    'selling_price' => 99,
                    'variation_price' => 99,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 7,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Savage 100 ml 3.4 oz',
                    'meta_keyword' => ['Men’s', 'Perfume'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Perfume'],
                'image_path' => 'personal_care/mens_care/mens_perfume',
            ],
            [
                'info' => [
                    'name' => 'Paco Rabanne 1 Million Eau',
                    'category' => 41,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 58,
                    'selling_price' => 78,
                    'variation_price' => 78,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Paco Rabanne 1 Million Eau',
                    'meta_keyword' => ['Men’s', 'Perfume'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Perfume'],
                'image_path' => 'personal_care/mens_care/mens_perfume',
            ],

            [
                'info' => [
                    'name' => 'Homme Dylan Blue Versace',
                    'category' => 41,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 65,
                    'selling_price' => 80,
                    'variation_price' => 80,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Homme Dylan Blue Versace',
                    'meta_keyword' => ['Men’s', 'Perfume'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Perfume'],
                'image_path' => 'personal_care/mens_care/mens_perfume',
            ],
            [
                'info' => [
                    'name' => 'NAUTICA Voyage Eau',
                    'category' => 41,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 55,
                    'selling_price' => 65,
                    'variation_price' => 65,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'NAUTICA Voyage Eau',
                    'meta_keyword' => ['Men’s', 'Perfume'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Perfume'],
                'image_path' => 'personal_care/mens_care/mens_perfume',
            ],
            [
                'info' => [
                    'name' => 'Royal Amber by Orientica',
                    'category' => 41,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 45,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Royal Amber by Orientica',
                    'meta_keyword' => ['Men’s', 'Perfume'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Perfume'],
                'image_path' => 'personal_care/mens_care/mens_perfume',
            ],
            [
                'info' => [
                    'name' => 'Cool Water by Davidoff Eau',
                    'category' => 41,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 65,
                    'selling_price' => 70,
                    'variation_price' => 70,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Cool Water by Davidoff Eau',
                    'meta_keyword' => ['Men’s', 'Perfume'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Perfume'],
                'image_path' => 'personal_care/mens_care/mens_perfume',
            ],
            [
                'info' => [
                    'name' => 'Hugo Boss The Scent',
                    'category' => 41,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 55,
                    'selling_price' => 80,
                    'variation_price' => 80,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Hugo Boss The Scent',
                    'meta_keyword' => ['Men’s', 'Perfume'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Perfume'],
                'image_path' => 'personal_care/mens_care/mens_perfume',
            ],

            [
                'info' => [
                    'name' => 'Ralph Lauren Polo Sport',
                    'category' => 41,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 23,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Ralph Lauren Polo Sport',
                    'meta_keyword' => ['Men’s', 'Perfume'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Perfume'],
                'image_path' => 'personal_care/mens_care/mens_perfume',
            ],

            // Shampoo & Conditioner
            [
                'info' => [
                    'name' => 'Professionals Men 2 in 1 Shampoo',
                    'category' => 42,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 68,
                    'selling_price' => 88,
                    'variation_price' => 88,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 8,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'seo' => [
                    'title' => 'Professionals Men 2-in-1 Shampoo',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/mens_care/shampoo_&_conditioner',
            ],
            [
                'info' => [
                    'name' => 'Old Spice Fiji 2in1 Shampoo',
                    'category' => 42,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 54,
                    'selling_price' => 74,
                    'variation_price' => 74,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'seo' => [
                    'title' => 'Old Spice Fiji 2in1 Shampoo',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/mens_care/shampoo_&_conditioner',
            ],

            [
                'info' => [
                    'name' => 'Citrus Rush 3-in-1 Shampoo',
                    'category' => 42,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 60,
                    'selling_price' => 78,
                    'variation_price' => 78,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'seo' => [
                    'title' => 'Citrus Rush 3-in-1 Shampoo',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/mens_care/shampoo_&_conditioner',
            ],
            [
                'info' => [
                    'name' => 'Old Spice Mens 2 in 1 Shampoo',
                    'category' => 42,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 52,
                    'selling_price' => 66,
                    'variation_price' => 66,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'seo' => [
                    'title' => 'Old Spice Mens 2 in 1 Shampoo',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/mens_care/shampoo_&_conditioner',
            ],
            [
                'info' => [
                    'name' => 'High Endurance Mens 3-in-1',
                    'category' => 42,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 47,
                    'selling_price' => 69,
                    'variation_price' => 69,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'seo' => [
                    'title' => 'High Endurance Mens 3-in-1',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/mens_care/shampoo_&_conditioner',
            ],
            [
                'info' => [
                    'name' => 'Man Jack Sea Salt Mens 3-in-1',
                    'category' => 42,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 51,
                    'selling_price' => 59,
                    'variation_price' => 59,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'seo' => [
                    'title' => 'Man Jack Sea Salt Mens 3-in-1',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/mens_care/shampoo_&_conditioner',
            ],
            [
                'info' => [
                    'name' => 'Dandruff 2 in 1 Shampoo',
                    'category' => 42,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 34,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'seo' => [
                    'title' => 'Dandruff 2 in 1 Shampoo',
                    'meta_keyword' => ['Shampoo', 'Conditioner'],
                    'description' => "<p>Experience the moisturizing power of the ocean in your shower. Suave Men 2-in-1 Ocean Charge Shampoo + Conditioner cleanses hair and conditions hair in one step, keeping your routine quick and easy. Now available in larger pump sizes for value and convenience. Works Hard. Smells Great. Made for men, this 2-in-1 shampoo and conditioner is infused with Panthenol, a pro vitamin known for its moisturizing properties.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Shampoo', 'Conditioner'],
                'image_path' => 'personal_care/mens_care/shampoo_&_conditioner',
            ],

            // Razors & Blades
            [
                'info' => [
                    'name' => 'Gillette Mach3 Mens Razor',
                    'category' => 43,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 68,
                    'selling_price' => 88,
                    'variation_price' => 88,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 8,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'seo' => [
                    'title' => 'Gillette Mach3 Mens Razor',
                    'meta_keyword' => ['Razors', 'Blades'],
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Razors', 'Blades'],
                'image_path' => 'personal_care/mens_care/razors_&_blades',
            ],
            [
                'info' => [
                    'name' => 'Mens Razor 5-Blade Refills',
                    'category' => 43,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 54,
                    'selling_price' => 74,
                    'variation_price' => 74,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'seo' => [
                    'title' => 'Mens Razor 5-Blade Refills',
                    'meta_keyword' => ['Razors', 'Blades'],
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Razors', 'Blades'],
                'image_path' => 'personal_care/mens_care/razors_&_blades',
            ],

            [
                'info' => [
                    'name' => 'Fusion5 Mens Razor Value Pack',
                    'category' => 43,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 60,
                    'selling_price' => 78,
                    'variation_price' => 78,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'seo' => [
                    'title' => 'Fusion5 Mens Razor Value Pack',
                    'meta_keyword' => ['Razors', 'Blades'],
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Razors', 'Blades'],
                'image_path' => 'personal_care/mens_care/razors_&_blades',
            ],
            [
                'info' => [
                    'name' => 'ProGlide Mens Razor Blades',
                    'category' => 43,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 52,
                    'selling_price' => 66,
                    'variation_price' => 66,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'seo' => [
                    'title' => 'ProGlide Mens Razor Blades',
                    'meta_keyword' => ['Razors', 'Blades'],
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Razors', 'Blades'],
                'image_path' => 'personal_care/mens_care/razors_&_blades',
            ],
            [
                'info' => [
                    'name' => 'Anti-Clogging Refillable Razors',
                    'category' => 43,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 47,
                    'selling_price' => 69,
                    'variation_price' => 69,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'seo' => [
                    'title' => 'Anti-Clogging Refillable Razors',
                    'meta_keyword' => ['Razors', 'Blades'],
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Razors', 'Blades'],
                'image_path' => 'personal_care/mens_care/razors_&_blades',
            ],
            [
                'info' => [
                    'name' => 'Venus for Pubic Hair and Skin',
                    'category' => 43,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 51,
                    'selling_price' => 59,
                    'variation_price' => 59,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'seo' => [
                    'title' => 'Venus for Pubic Hair and Skin',
                    'meta_keyword' => ['Razors', 'Blades'],
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Razors', 'Blades'],
                'image_path' => 'personal_care/mens_care/razors_&_blades',
            ],
            [
                'info' => [
                    'name' => 'Flex 4 Disposable Razors',
                    'category' => 43,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 34,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'seo' => [
                    'title' => 'Flex 4 Disposable Razors',
                    'meta_keyword' => ['Razors', 'Blades'],
                    'description' => "<p>Each razor blade refill is engineered to last up to 15 comfortable shaves, so you can get the most of every shave. The Gillette Mach3 razors for men have stronger-than-steel blades stay sharper longer (vs. Sensor3). Along with durability, these Gillette razors feature a lubrication strip that glides to help protect your skin from redness, while soft microfins gently stretch and smooth skin, preparing hairs to be cut for the optimal shaving experience.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Razors', 'Blades'],
                'image_path' => 'personal_care/mens_care/razors_&_blades',
            ],

            // Men’s Facewash
            [
                'info' => [
                    'name' => 'NIVEA MEN Face Wash',
                    'category' => 44,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'seo' => [
                    'title' => 'NIVEA MEN Face Wash',
                    'meta_keyword' => ['Men’s', 'Facewash'],
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Men’s', 'Facewash'],
                'image_path' => 'personal_care/mens_care/mens_facewash',
            ],

            [
                'info' => [
                    'name' => 'Oil-Free Salicylic Acid Face Wash',
                    'category' => 44,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 30,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'seo' => [
                    'title' => 'Oil-Free Salicylic Acid Face Wash',
                    'meta_keyword' => ['Men’s', 'Facewash'],
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Men’s', 'Facewash'],
                'image_path' => 'personal_care/mens_care/mens_facewash',
            ],

            [
                'info' => [
                    'name' => 'Day and Night Acne Face Wash',
                    'category' => 44,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 5,
                    'selling_price' => 10,
                    'variation_price' => 10,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'seo' => [
                    'title' => 'Day and Night Acne Face Wash',
                    'meta_keyword' => ['Men’s', 'Facewash'],
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Men’s', 'Facewash'],
                'image_path' => 'personal_care/mens_care/mens_facewash',
            ],

            [
                'info' => [
                    'name' => 'Salicylic Acid Face Wash',
                    'category' => 44,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 13,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",

                ],
                'seo' => [
                    'title' => '2% Salicylic Acid Face Wash',
                    'meta_keyword' => ['Men’s', 'Facewash'],
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Men’s', 'Facewash'],
                'image_path' => 'personal_care/mens_care/mens_facewash',
            ],

            [
                'info' => [
                    'name' => 'Soothing Cream Acne Cleanser',
                    'category' => 44,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 24,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'seo' => [
                    'title' => 'Soothing Cream Acne Cleanser',
                    'meta_keyword' => ['Men’s', 'Facewash'],
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Men’s', 'Facewash'],
                'image_path' => 'personal_care/mens_care/mens_facewash',
            ],

            [
                'info' => [
                    'name' => 'Moisturizing Aloe Face Wash',
                    'category' => 44,
                    'brand' => 6,
                    'unit_id' => 6,
                    'buying_price' => 26,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'seo' => [
                    'title' => 'Moisturizing Aloe Face Wash',
                    'meta_keyword' => ['Men’s', 'Facewash'],
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Men’s', 'Facewash'],
                'image_path' => 'personal_care/mens_care/mens_facewash',
            ],

            [
                'info' => [
                    'name' => 'Fragrance Free Gentle Face Cleanser',
                    'category' => 44,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'seo' => [
                    'title' => 'Fragrance Free Gentle Face Cleanser',
                    'meta_keyword' => ['Men’s', 'Facewash'],
                    'description' => "<p>Neutrogena Oil-Free Acne Wash is the #1 dermatologist recommended acne-fighting facial cleanser. This daily acne face wash contains 2% salicylic acid acne medication and is formulated to gently clean deep into pores for clearer skin and even helps treat acne before it emerges. Clinically proven MicroClear technology helps boost the delivery of acne medication to help clear up acne and blackheads, and even helps prevent future breakouts.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Men’s', 'Facewash'],
                'image_path' => 'personal_care/mens_care/mens_facewash',
            ],

            // Personal Care -> HandWash -> Liquid Handwash

            [
                'info' => [
                    'name' => 'Liquid Hand Soap Refill',
                    'category' => 46,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 180,
                    'selling_price' => 270,
                    'variation_price' => 270,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'seo' => [
                    'title' => 'Liquid Hand Soap Refill',
                    'meta_keyword' => ['Liquid', 'Handwash'],
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Liquid Hand', 'Soap Refill'],
                'image_path' => 'personal_care/handwash/liquid_handwash',
            ],
            [
                'info' => [
                    'name' => 'Essentials Liquid Hand Soap',
                    'category' => 46,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 180,
                    'selling_price' => 270,
                    'variation_price' => 270,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'seo' => [
                    'title' => 'Essentials Liquid Hand Soap',
                    'meta_keyword' => ['Liquid', 'Handwash'],
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Essentials Liquid', 'Hand Soap'],
                'image_path' => 'personal_care/handwash/liquid_handwash',
            ],
            [
                'info' => [
                    'name' => 'Antibacterial Soap Refill',
                    'category' => 46,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 180,
                    'selling_price' => 280,
                    'variation_price' => 280,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'seo' => [
                    'title' => 'Antibacterial Soap Refill',
                    'meta_keyword' => ['Liquid', 'Handwash'],
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Antibacterial', 'Soap Refill'],
                'image_path' => 'personal_care/handwash/liquid_handwash',
            ],
            [
                'info' => [
                    'name' => 'Juicy Peach Liquid Hand Soap',
                    'category' => 46,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 180,
                    'selling_price' => 280,
                    'variation_price' => 280,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'seo' => [
                    'title' => 'Juicy Peach Liquid Hand Soap',
                    'meta_keyword' => ['Liquid', 'Handwash'],
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Juicy Peach', 'Liquid Hand Soap'],
                'image_path' => 'personal_care/handwash/liquid_handwash',
            ],
            [
                'info' => [
                    'name' => 'Foaming Hand Soap',
                    'category' => 46,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 190,
                    'selling_price' => 290,
                    'variation_price' => 290,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'seo' => [
                    'title' => 'Foaming Hand Soap',
                    'meta_keyword' => ['Liquid', 'Handwash'],
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Foaming', 'Hand Soap'],
                'image_path' => 'personal_care/handwash/liquid_handwash',
            ],
            [
                'info' => [
                    'name' => 'Milk & Honey Hand Soap Refill',
                    'category' => 46,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 190,
                    'selling_price' => 290,
                    'variation_price' => 290,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'seo' => [
                    'title' => 'Milk & Honey Hand Soap Refill',
                    'meta_keyword' => ['Liquid', 'Handwash'],
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Milk & Honey', 'Hand Soap Refill'],
                'image_path' => 'personal_care/handwash/liquid_handwash',
            ],
            [
                'info' => [
                    'name' => 'Foaming Hand Soap',
                    'category' => 46,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 190,
                    'selling_price' => 300,
                    'variation_price' => 300,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'seo' => [
                    'title' => 'Foaming Hand Soap',
                    'meta_keyword' => ['Liquid', 'Handwash'],
                    'description' => "<p>Bask in the light scent of Soft soap Liquid Hand Soap, Aquarium Series 50 oz. Wash away dirt and bacteria with this hand wash for good hand hygiene (health care agencies recommend washing hands in warm water for at least 2 seconds to wash away dirt and bacteria). This fresh formula features your favorite fish.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Foaming', 'Hand Soap'],
                'image_path' => 'personal_care/handwash/liquid_handwash',
            ],

            // Personal Care -> HandWash -> Hand Sanitizer
            [
                'info' => [
                    'name' => 'Hand Sanitizer Naturals Gel',
                    'category' => 47,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 80,
                    'selling_price' => 100,
                    'variation_price' => 100,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'seo' => [
                    'title' => 'Hand Sanitizer Naturals Gel',
                    'meta_keyword' => ['Hand', 'Sanitizer'],
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Foaming', 'Hand Soap'],
                'image_path' => 'personal_care/handwash/hand_sanitizer',
            ],
            [
                'info' => [
                    'name' => 'Hand Sanitizer Calming Lavender',
                    'category' => 47,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 90,
                    'selling_price' => 110,
                    'variation_price' => 110,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'seo' => [
                    'title' => 'Hand Sanitizer Calming Lavender',
                    'meta_keyword' => ['Hand', 'Sanitizer'],
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Foaming', 'Hand Soap'],
                'image_path' => 'personal_care/handwash/hand_sanitizer',
            ],
            [
                'info' => [
                    'name' => 'Hand Sanitizer Gel',
                    'category' => 47,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 100,
                    'selling_price' => 120,
                    'variation_price' => 120,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'seo' => [
                    'title' => 'Hand Sanitizer Gel',
                    'meta_keyword' => ['Hand', 'Sanitizer'],
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Hand Sanitizer', 'Gel'],
                'image_path' => 'personal_care/handwash/hand_sanitizer',
            ],
            [
                'info' => [
                    'name' => 'Aloe Hand Sanitizer 3 fl oz',
                    'category' => 47,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 110,
                    'selling_price' => 130,
                    'variation_price' => 130,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'seo' => [
                    'title' => 'Aloe Hand Sanitizer 3 fl oz',
                    'meta_keyword' => ['Hand', 'Sanitizer'],
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Hand Sanitizer', 'Aloe'],
                'image_path' => 'personal_care/handwash/hand_sanitizer',
            ],
            [
                'info' => [
                    'name' => 'Hand Sanitizer Mint',
                    'category' => 47,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 120,
                    'selling_price' => 140,
                    'variation_price' => 140,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'seo' => [
                    'title' => 'Hand Sanitizer Mint',
                    'meta_keyword' => ['Hand', 'Sanitizer'],
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Hand Sanitizer', 'Mint'],
                'image_path' => 'personal_care/handwash/hand_sanitizer',
            ],
            [
                'info' => [
                    'name' => 'Sea Salt Hand Sanitizer Gel',
                    'category' => 47,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 130,
                    'selling_price' => 150,
                    'variation_price' => 150,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'seo' => [
                    'title' => 'Sea Salt Hand Sanitizer Gel',
                    'meta_keyword' => ['Hand', 'Sanitizer'],
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Hand Sanitizer Gel', 'Sea Salt'],
                'image_path' => 'personal_care/handwash/hand_sanitizer',
            ],
            [
                'info' => [
                    'name' => '80 Percentage Alcohol Hand Sanitizer',
                    'category' => 47,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 140,
                    'selling_price' => 160,
                    'variation_price' => 160,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'seo' => [
                    'title' => '80 Percentage Alcohol Hand Sanitizer',
                    'meta_keyword' => ['Hand', 'Sanitizer'],
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Hand Sanitizer', 'Alcohol'],
                'image_path' => 'personal_care/handwash/hand_sanitizer',
            ],
            [
                'info' => [
                    'name' => 'Free Foaming Hand Sanitizer',
                    'category' => 47,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 140,
                    'selling_price' => 160,
                    'variation_price' => 160,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'seo' => [
                    'title' => 'Free Foaming Hand Sanitizer',
                    'meta_keyword' => ['Hand', 'Sanitizer'],
                    'description' => "<p>Help your family and those you care for kill germs on their hands with PURELL Advanced Hand Sanitizer Naturals. The same 99.99 percent germ-killing power of PURELL hand sanitizer that you know and trust is available in a simple formulation, made with naturally derived plant-based ethanol.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Hand Sanitizer', 'Free Foaming'],
                'image_path' => 'personal_care/handwash/hand_sanitizer',
            ],

            // Toothpastes
            [
                'info' => [
                    'name' => 'Pronamel Gentle Toothpaste',
                    'category' => 49,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 8,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 8,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'seo' => [
                    'title' => 'Pronamel Gentle Toothpaste',
                    'meta_keyword' => ['Toothpastes'],
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Toothpastes'],
                'image_path' => 'personal_care/oral_care/toothpastes',
            ],

            [
                'info' => [
                    'name' => 'Cavity Protection Toothpaste',
                    'category' => 49,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 8,
                    'selling_price' => 15,
                    'variation_price' => 15,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'seo' => [
                    'title' => 'Cavity Protection Toothpaste',
                    'meta_keyword' => ['Toothpastes'],
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Toothpastes'],
                'image_path' => 'personal_care/oral_care/toothpastes',
            ],

            [
                'info' => [
                    'name' => 'Radiant Mint Toothpaste',
                    'category' => 49,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 18,
                    'selling_price' => 26,
                    'variation_price' => 26,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'seo' => [
                    'title' => 'Radiant Mint Toothpaste',
                    'meta_keyword' => ['Toothpastes'],
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Toothpastes'],
                'image_path' => 'personal_care/oral_care/toothpastes',
            ],

            [
                'info' => [
                    'name' => 'Scope Toothpaste',
                    'category' => 49,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 23,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",

                ],
                'seo' => [
                    'title' => 'Scope Toothpaste',
                    'meta_keyword' => ['Toothpastes'],
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Toothpastes'],
                'image_path' => 'personal_care/oral_care/toothpastes',
            ],

            [
                'info' => [
                    'name' => 'Triple Action Toothpaste',
                    'category' => 49,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 32,
                    'selling_price' => 43,
                    'variation_price' => 43,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'seo' => [
                    'title' => 'Triple Action Toothpaste',
                    'meta_keyword' => ['Toothpastes'],
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Toothpastes'],
                'image_path' => 'personal_care/oral_care/toothpastes',
            ],

            [
                'info' => [
                    'name' => 'Sensitive Toothpaste',
                    'category' => 49,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 6,
                    'selling_price' => 23,
                    'variation_price' => 23,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'seo' => [
                    'title' => 'Sensitive Toothpaste',
                    'meta_keyword' => ['Toothpastes'],
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Toothpastes'],
                'image_path' => 'personal_care/oral_care/toothpastes',
            ],

            [
                'info' => [
                    'name' => 'Advanced Radiant Mint',
                    'category' => 49,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 5,
                    'selling_price' => 15,
                    'variation_price' => 15,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 6,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'seo' => [
                    'title' => 'Advanced Radiant Mint',
                    'meta_keyword' => ['Toothpastes'],
                    'description' => "<p>Gentle Whitening Enamel Toothpaste for Sensitive Teeth is an enamel protection toothpaste that cleans and polishes away stains for brighter, healthier teeth. Strengthening and re-hardening enamel, this cavity protection toothpaste contains an optimized fluoride formulation that boosts calcium delivery, aiding in the overall remineralization process of your teeth.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Toothpastes'],
                'image_path' => 'personal_care/oral_care/toothpastes',
            ],

            // Toothbrushes

            [
                'info' => [
                    'name' => 'Clean Full Head Toothbrush',
                    'category' => 50,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 65,
                    'selling_price' => 80,
                    'variation_price' => 80,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Clean Full Head Toothbrush',
                    'meta_keyword' => ['Toothbrushes'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Toothbrushes'],
                'image_path' => 'personal_care/oral_care/toothbrushes',
            ],
            [
                'info' => [
                    'name' => 'Sonic Electric Toothbrush',
                    'category' => 50,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 55,
                    'selling_price' => 65,
                    'variation_price' => 65,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Sonic Electric Toothbrush',
                    'meta_keyword' => ['Toothbrushes'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Toothbrushes'],
                'image_path' => 'personal_care/oral_care/toothbrushes',
            ],
            [
                'info' => [
                    'name' => 'Essentials Medium Toothbrush',
                    'category' => 50,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 45,
                    'selling_price' => 60,
                    'variation_price' => 60,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Essentials Medium Toothbrush',
                    'meta_keyword' => ['Toothbrushes'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Toothbrushes'],
                'image_path' => 'personal_care/oral_care/toothbrushes',
            ],
            [
                'info' => [
                    'name' => 'Zig Zag Charcoal Toothbrush',
                    'category' => 50,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 65,
                    'selling_price' => 70,
                    'variation_price' => 70,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Zig Zag Charcoal Toothbrush',
                    'meta_keyword' => ['Toothbrushes'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Toothbrushes'],
                'image_path' => 'personal_care/oral_care/toothbrushes',
            ],
            [
                'info' => [
                    'name' => 'Max Manual Toothbrushes',
                    'category' => 50,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 55,
                    'selling_price' => 80,
                    'variation_price' => 80,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Max Manual Toothbrushes',
                    'meta_keyword' => ['Toothbrushes'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Toothbrushes'],
                'image_path' => 'personal_care/oral_care/toothbrushes',
            ],

            [
                'info' => [
                    'name' => 'Adult Medium Toothbrush',
                    'category' => 50,
                    'brand' => 5,
                    'unit_id' => 1,
                    'buying_price' => 23,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'seo' => [
                    'title' => 'Adult Medium Toothbrush',
                    'meta_keyword' => ['Toothbrushes'],
                    'description' => "<p>Versace Pour Homme Dylan Blue by Versace provides a delicate balance of citrus, spicy and musk accords, creating an ideal daily scent. The fragrance opens with fresh top notes of water, grapefruit, fig and bergamot. These are followed by a complex middle blend of floral and woodsy violet leaf, papyrus and patchouli mixed with spicy black pepper and ambroxan.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Toothbrushes'],
                'image_path' => 'personal_care/oral_care/toothbrushes',
            ],

            // Health & Wellness -> Keto Food
            [
                'info' => [
                    'name' => 'Keto Chocolate Mix',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 140,
                    'selling_price' => 160,
                    'variation_price' => 160,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Keto Chocolate Mix',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Keto', 'Chocolate Mix'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Vanilla Almond Crunch Cereal',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 150,
                    'selling_price' => 170,
                    'variation_price' => 170,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 15,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Vanilla Almond Crunch Cereal',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Vanilla Almond Crunch', 'Cereal'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Keto Pancake & Waffle Mix',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 160,
                    'selling_price' => 180,
                    'variation_price' => 180,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 30,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Keto Pancake & Waffle Mix',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Keto Pancake', 'Waffle Mix'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Sugar Nut and Seed Bars',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 100,
                    'selling_price' => 120,
                    'variation_price' => 120,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Sugar Nut and Seed Bars',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Sugar Nut', 'Seed Bars'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Yogurt Cultured Dairy Snack',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 110,
                    'selling_price' => 130,
                    'variation_price' => 130,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Yogurt Cultured Dairy Snack',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Yogurt Cultured', 'Dairy Snack'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Keto Cheese, Nut & Seed',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 200,
                    'selling_price' => 210,
                    'variation_price' => 210,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Keto Cheese, Nut & Seed',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['keto Cheese', 'Nut & Seed'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'HighKey Sugar Free Cookie',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 200,
                    'selling_price' => 210,
                    'variation_price' => 210,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'HighKey Sugar Free Cookie',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [4],
                'tags' => ['HighKey Cookie', 'Sugar Free'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Crunch Keto Friendly Cereal',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 200,
                    'selling_price' => 220,
                    'variation_price' => 220,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Crunch Keto Friendly Cereal',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Crunch Keto ', 'Friendly Cereal'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Keto Blueberry Nut Granola',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 200,
                    'selling_price' => 230,
                    'variation_price' => 230,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Keto Blueberry Nut Granola',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Keto Blueberry', 'Nut Granola'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Keto Blueberry Free Scone',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 220,
                    'selling_price' => 240,
                    'variation_price' => 240,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Keto Blueberry Free Scone',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Keto Blueberry', ' Free Scone'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Sugar Free Blueberry Muffin',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 220,
                    'selling_price' => 250,
                    'variation_price' => 250,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Sugar Free Blueberry Muffin',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Sugar Free', 'Blueberry Muffin'],
                'image_path' => 'health_&_wellness/keto_food',
            ],
            [
                'info' => [
                    'name' => 'Toasted Almond Granola Cereal',
                    'category' => 52,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 220,
                    'selling_price' => 250,
                    'variation_price' => 250,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'seo' => [
                    'title' => 'Toasted Almond Granola Cereal',
                    'meta_keyword' => ['Keto', 'Food'],
                    'description' => "<p>Treat yourself to a delicious and healthy snack with Great Value Keto Chocolate Trail Mix. This appetizing blend includes almonds, peanuts, walnuts, pepitas, and semi-sweet chocolate chunks. With eight 1.5-ounce pouches, this box is the perfect treat to bring with you on your next adventure, whether you're mountain climbing, whitewater rafting, or just a stroll through the park.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Toasted Almond', 'Granola Cereal'],
                'image_path' => 'health_&_wellness/keto_food',
            ],

            // Health & Wellness -> Antiseptics
            [
                'info' => [
                    'name' => 'Pain Relieving Antiseptic',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 220,
                    'selling_price' => 250,
                    'variation_price' => 250,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Pain Relieving Antiseptic',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Relieving Antiseptic', 'Pain'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            [
                'info' => [
                    'name' => 'Pain Relieving Antiseptic Spray',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 220,
                    'selling_price' => 260,
                    'variation_price' => 260,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Pain Relieving Antiseptic Spray',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Pain Relieving Antiseptic', 'Spray'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            [
                'info' => [
                    'name' => 'Antiseptic & Analgesic Spray',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 220,
                    'selling_price' => 270,
                    'variation_price' => 270,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Antiseptic & Analgesic Spray',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [1, 4],
                'tags' => ['Antiseptic & Analgesic', 'Spray'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            [
                'info' => [
                    'name' => 'Wound Wash Antiseptic Liquid',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 5,
                    'buying_price' => 230,
                    'selling_price' => 280,
                    'variation_price' => 280,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Wound Wash Antiseptic Liquid',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [1, 4],
                'tags' => ['Wound Wash', 'Antiseptic Liquid'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            [
                'info' => [
                    'name' => 'Equate Liquid Bandage',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 230,
                    'selling_price' => 290,
                    'variation_price' => 290,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Equate Liquid Bandage',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [1, 4],
                'tags' => ['Equate Liquid ', 'Bandage'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            [
                'info' => [
                    'name' => 'Antibiotic Bacitracin Ointment',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 250,
                    'selling_price' => 300,
                    'variation_price' => 300,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Antibiotic Bacitracin Ointment',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Antibiotic Bacitracin', 'Ointment'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            [
                'info' => [
                    'name' => 'Clinical Solutions Gum',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 260,
                    'selling_price' => 310,
                    'variation_price' => 310,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Clinical Solutions Gum',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Clinical Solutions', 'Gum'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            [
                'info' => [
                    'name' => 'Topical Antibiotic Ointment',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 260,
                    'selling_price' => 320,
                    'variation_price' => 320,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Topical Antibiotic Ointment',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Topical Antibiotic', 'Ointment'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            [
                'info' => [
                    'name' => 'Bactine Antiseptic,Bottle',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 270,
                    'selling_price' => 330,
                    'variation_price' => 330,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Bactine Antiseptic,Bottle',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Bactine Antiseptic', 'Bottle'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            [
                'info' => [
                    'name' => 'Wound Antiseptic Dressing',
                    'category' => 53,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 270,
                    'selling_price' => 330,
                    'variation_price' => 330,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'seo' => [
                    'title' => 'Wound Antiseptic Dressing',
                    'meta_keyword' => ['Antiseptics'],
                    'description' => "<p>Clean and relieve the pain of minor wounds with Band-Aid Brand Pain Relieving Antiseptic Cleansing Liquid. Formulated with the topical analgesic lidocaine HCl, this antiseptic liquid helps relieve the pain and discomfort of minor cuts, scrapes, and burns.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Wound Antiseptic', 'Dressing'],
                'image_path' => 'health_&_wellness/antiseptics',
            ],
            // Health & Wellness -> Food Supplements
            [
                'info' => [
                    'name' => 'Vegetable & Fruit Whole Food',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 270,
                    'selling_price' => 330,
                    'variation_price' => 330,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Vegetable & Fruit Whole Food',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Vegetable', 'Fruit Whole Food'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],
            [
                'info' => [
                    'name' => 'Super B Complex Vitamin',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 270,
                    'selling_price' => 330,
                    'variation_price' => 330,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Super B Complex Vitamin',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Super B', 'Complex Vitamin'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],
            [
                'info' => [
                    'name' => 'Fruits and Veggies Supplement',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 270,
                    'selling_price' => 340,
                    'variation_price' => 340,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Fruits and Veggies Supplement',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Fruits', 'Veggies Supplement'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],
            [
                'info' => [
                    'name' => 'Greens Superfood Supplement',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 280,
                    'selling_price' => 350,
                    'variation_price' => 350,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Greens Superfood Supplement',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Greens Superfood', 'Supplement'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],
            [
                'info' => [
                    'name' => 'Blood Pressure Supplement',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 280,
                    'selling_price' => 360,
                    'variation_price' => 360,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Blood Pressure Supplement',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Blood Pressure', 'Supplement'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],
            [
                'info' => [
                    'name' => 'Plus Supplement 200mg',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 280,
                    'selling_price' => 370,
                    'variation_price' => 370,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Plus Supplement 200mg',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Plus Supplement', '200mg'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],
            [
                'info' => [
                    'name' => 'Super Food Supplement',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 280,
                    'selling_price' => 380,
                    'variation_price' => 380,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Super Food Supplement',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Super Food', 'Supplement'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],
            [
                'info' => [
                    'name' => 'Fruits and Veggies Supplement',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 280,
                    'selling_price' => 390,
                    'variation_price' => 390,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Fruits and Veggies Supplement',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Fruits', 'Veggies Supplement'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],
            [
                'info' => [
                    'name' => 'Whole Food Supplement',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 280,
                    'selling_price' => 400,
                    'variation_price' => 400,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Whole Food Supplement',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Whole', 'Food Supplement'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],
            [
                'info' => [
                    'name' => 'Whole-Food Iodine Supplement',
                    'category' => 54,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 290,
                    'selling_price' => 410,
                    'variation_price' => 410,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'seo' => [
                    'title' => 'Whole-Food Iodine Supplement',
                    'meta_keyword' => ['Food', 'Supplements'],
                    'description' => "<p>Now with our exclusive Vegetable &amp; Fruit tablets you can help yourself to a wealth of health. You not only get vitamins and minerals, but you also get the immune-supporting natural plant nutrients that act as protectors to the body. For peace of mind and to help your body help itself, join thousands of others who make Vegetable &amp; Fruit tablets a part of their daily health program.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Whole-Food', 'Iodine Supplement'],
                'image_path' => 'health_&_wellness/food_supplements',
            ],

            // Health and wellness -> Herbal and Digestive Aids
            [
                'info' => [
                    'name' => 'Instant Drink Mix',
                    'category' => 55,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 100,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'seo' => [
                    'title' => 'Instant Drink Mix',
                    'meta_keyword' => ['Herbal', 'Digestive Aids'],
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'taxes' => [1],
                'tags' => ['Instant', 'Drink Mix'],
                'image_path' => 'health_&_wellness/herbal_&_digestive_aids',
            ],
            [
                'info' => [
                    'name' => 'Organic Pure Ginger Root',
                    'category' => 55,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 100,
                    'selling_price' => 220,
                    'variation_price' => 220,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'seo' => [
                    'title' => 'Organic Pure Ginger Root',
                    'meta_keyword' => ['Herbal', 'Digestive Aids'],
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Organic Pure', 'Ginger Root'],
                'image_path' => 'health_&_wellness/herbal_&_digestive_aids',
            ],
            [
                'info' => [
                    'name' => 'Herbal Zap Digestive Cool',
                    'category' => 55,
                    'brand' => null,
                    'unit_id' => 2,
                    'buying_price' => 120,
                    'selling_price' => 240,
                    'variation_price' => 240,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'seo' => [
                    'title' => 'Herbal Zap Digestive Cool',
                    'meta_keyword' => ['Herbal', 'Digestive Aids'],
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Herbal Zap', 'Digestive Cool'],
                'image_path' => 'health_&_wellness/herbal_&_digestive_aids',
            ],
            [
                'info' => [
                    'name' => 'Dr. Schulze’s Intestinal Formula',
                    'category' => 55,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 120,
                    'selling_price' => 250,
                    'variation_price' => 250,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'seo' => [
                    'title' => 'Dr. Schulze’s Intestinal Formula',
                    'meta_keyword' => ['Herbal', 'Digestive Aids'],
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Dr. Schulze’s', 'Intestinal Formula'],
                'image_path' => 'health_&_wellness/herbal_&_digestive_aids',
            ],
            [
                'info' => [
                    'name' => 'Digestive Enzymes Herbal',
                    'category' => 55,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 140,
                    'selling_price' => 260,
                    'variation_price' => 260,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'seo' => [
                    'title' => 'Digestive Enzymes Herbal',
                    'meta_keyword' => ['Herbal', 'Digestive Aids'],
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'taxes' => [1, 2],
                'tags' => ['Digestive Enzymes', 'Herbal'],
                'image_path' => 'health_&_wellness/herbal_&_digestive_aids',
            ],
            [
                'info' => [
                    'name' => 'Herbal Uric Acid Cleanse',
                    'category' => 55,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 150,
                    'selling_price' => 270,
                    'variation_price' => 270,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'seo' => [
                    'title' => 'Herbal Uric Acid Cleanse',
                    'meta_keyword' => ['Herbal', 'Digestive Aids'],
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'taxes' => [1, 3],
                'tags' => ['Herbal Uric ', 'Acid Cleanse'],
                'image_path' => 'health_&_wellness/herbal_&_digestive_aids',
            ],
            [
                'info' => [
                    'name' => 'Enzymedica Digest Spectrum',
                    'category' => 55,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 160,
                    'selling_price' => 280,
                    'variation_price' => 280,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'seo' => [
                    'title' => 'Enzymedica Digest Spectrum',
                    'meta_keyword' => ['Herbal', 'Digestive Aids'],
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'taxes' => [1, 4],
                'tags' => ['Enzymedica ', 'Digest Spectrum'],
                'image_path' => 'health_&_wellness/herbal_&_digestive_aids',
            ],
            [
                'info' => [
                    'name' => 'Herbal Cleanse Pills',
                    'category' => 55,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 180,
                    'selling_price' => 290,
                    'variation_price' => 290,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'seo' => [
                    'title' => 'Herbal Cleanse Pills',
                    'meta_keyword' => ['Herbal', 'Digestive Aids'],
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Herbal', 'Cleanse Pills'],
                'image_path' => 'health_&_wellness/herbal_&_digestive_aids',
            ],
            [
                'info' => [
                    'name' => 'CO2 Extracted Milk',
                    'category' => 55,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 200,
                    'selling_price' => 300,
                    'variation_price' => 300,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'seo' => [
                    'title' => 'CO2 Extracted Milk',
                    'meta_keyword' => ['Herbal', 'Digestive Aids'],
                    'description' => "<p>Turmeric &amp; Black Pepper Extracts can aid in immune support and support digestive health.* It's rich in antioxidants with natural ingredients such as turmeric and black pepper. It comes in a tasty saffron &amp; almond flavor making it easy to take.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['CO2', 'Extracted Milk'],
                'image_path' => 'health_&_wellness/herbal_&_digestive_aids',
            ],

            // Diapers
            [
                'info' => [
                    'name' => 'Dry & Gentle Diapers',
                    'category' => 57,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 51,
                    'selling_price' => 59,
                    'variation_price' => 59,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'seo' => [
                    'title' => 'Dry & Gentle Diapers',
                    'meta_keyword' => ['Diapers'],
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Diapers'],
                'image_path' => 'baby_care/diapers',
            ],
            [
                'info' => [
                    'name' => 'Disposable Baby Diapers',
                    'category' => 57,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 34,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'seo' => [
                    'title' => 'Disposable Baby Diapers',
                    'meta_keyword' => ['Diapers'],
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Diapers'],
                'image_path' => 'baby_care/diapers',
            ],

            [
                'info' => [
                    'name' => 'Baby Dry Diapers Size 4',
                    'category' => 57,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Dry Diapers Size 4',
                    'meta_keyword' => ['Diapers'],
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Diapers'],
                'image_path' => 'baby_care/diapers',
            ],

            [
                'info' => [
                    'name' => 'Premium Diapers Size 3',
                    'category' => 57,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 30,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'seo' => [
                    'title' => 'Premium Diapers Size 3',
                    'meta_keyword' => ['Diapers'],
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Diapers'],
                'image_path' => 'baby_care/diapers',
            ],

            [
                'info' => [
                    'name' => 'Snugglers Baby Diapers, Size 2',
                    'category' => 57,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 5,
                    'selling_price' => 10,
                    'variation_price' => 10,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'seo' => [
                    'title' => 'Snugglers Baby Diapers, Size 2',
                    'meta_keyword' => ['Diapers'],
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Diapers'],
                'image_path' => 'baby_care/diapers',
            ],

            [
                'info' => [
                    'name' => 'Premium Baby Diapers',
                    'category' => 57,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 13,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",

                ],
                'seo' => [
                    'title' => 'Premium Baby Diapers',
                    'meta_keyword' => ['Diapers'],
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Diapers'],
                'image_path' => 'baby_care/diapers',
            ],

            [
                'info' => [
                    'name' => 'Overnight Diapers Size 6',
                    'category' => 57,
                    'brand' => 5,
                    'unit_id' => 6,
                    'buying_price' => 24,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::YES,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'seo' => [
                    'title' => 'Overnight Diapers Size 6',
                    'meta_keyword' => ['Diapers'],
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Diapers'],
                'image_path' => 'baby_care/diapers',
            ],

            [
                'info' => [
                    'name' => 'Skin Smart Baby Diapers, Size 1',
                    'category' => 57,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 26,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'seo' => [
                    'title' => 'Skin Smart Baby Diapers, Size 1',
                    'meta_keyword' => ['Diapers'],
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Diapers'],
                'image_path' => 'baby_care/diapers',
            ],

            [
                'info' => [
                    'name' => 'Leakguards Newborn Diapers',
                    'category' => 57,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'seo' => [
                    'title' => 'Leakguards Newborn Diapers',
                    'meta_keyword' => ['Diapers'],
                    'description' => "<p>No job is too big, no pup is too small! Luvs diapers with new Paw Patrol designs have your backâand their butts. Luvs now has up to 12 hours of protection, day and night. Like Chase and Marshall would say, our highly trained paws are at your service. And diaper leaks? Weâre on the case with nonstop leak protection. Luvs Triple Leak guards absorb quickly to help stop diaper leaks before they happen.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Diapers'],
                'image_path' => 'baby_care/diapers',
            ],

            // Baby Foods
            [
                'info' => [
                    'name' => 'Baby Food, Banana Blackberry',
                    'category' => 58,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 24,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Food, Banana Blackberry',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],
            [
                'info' => [
                    'name' => 'Baby Food, Sweet Potato',
                    'category' => 58,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 51,
                    'selling_price' => 59,
                    'variation_price' => 59,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Food, Sweet Potato',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],
            [
                'info' => [
                    'name' => 'Baby Food, Apple Strawberry',
                    'category' => 58,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 34,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Food, Apple Strawberry',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],

            [
                'info' => [
                    'name' => 'Baby Foods, Vegetable Chicken',
                    'category' => 58,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 15,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Foods, Vegetable Chicken',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],

            [
                'info' => [
                    'name' => 'Baby Food, Banana Orange',
                    'category' => 58,
                    'brand' => 2,
                    'unit_id' => 3,
                    'buying_price' => 30,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Food, Banana Orange',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],

            [
                'info' => [
                    'name' => 'Baby Foods, Chicken Noodle',
                    'category' => 58,
                    'brand' => 3,
                    'unit_id' => 3,
                    'buying_price' => 5,
                    'selling_price' => 10,
                    'variation_price' => 10,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Foods, Chicken Noodle',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],

            [
                'info' => [
                    'name' => 'Baby Food, Apple Blueberry',
                    'category' => 58,
                    'brand' => 4,
                    'unit_id' => 3,
                    'buying_price' => 13,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",

                ],
                'seo' => [
                    'title' => 'Baby Food, Apple Blueberry',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],

            [
                'info' => [
                    'name' => 'Baby Food, Pear Cinnamon',
                    'category' => 58,
                    'brand' => null,
                    'unit_id' => 3,
                    'buying_price' => 24,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Food, Pear Cinnamon',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],

            [
                'info' => [
                    'name' => 'Baby Food, Butternut Squash',
                    'category' => 58,
                    'brand' => 6,
                    'unit_id' => 3,
                    'buying_price' => 26,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Food, Butternut Squash',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],

            [
                'info' => [
                    'name' => 'Baby Food, Banana Apple Pear',
                    'category' => 58,
                    'brand' => 4,
                    'unit_id' => 3,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Food, Banana Apple Pear',
                    'meta_keyword' => ['Baby', 'Foods'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Baby', 'Foods'],
                'image_path' => 'baby_care/baby_foods',
            ],

            // Baby Skincare
            [
                'info' => [
                    'name' => 'Sensitive Skin Gift Set for Baby',
                    'category' => 59,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 24,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Sensitive Skin Gift Set for Baby',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],

            [
                'info' => [
                    'name' => 'Ointment Diaper Rash Cream',
                    'category' => 59,
                    'brand' => 6,
                    'unit_id' => 6,
                    'buying_price' => 26,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Ointment Diaper Rash Cream',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],

            [
                'info' => [
                    'name' => 'Moisture Body Lotion for Baby',
                    'category' => 59,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Moisture Body Lotion for Baby',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],

            [
                'info' => [
                    'name' => 'Johnsons Baby Oil',
                    'category' => 59,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 24,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Johnsons Baby Oil',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],
            [
                'info' => [
                    'name' => 'Magic Calming Body Lotion',
                    'category' => 59,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 51,
                    'selling_price' => 59,
                    'variation_price' => 59,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Magic Calming Body Lotion',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],
            [
                'info' => [
                    'name' => 'Magic Gentle Baby Lotion',
                    'category' => 59,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 34,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Magic Gentle Baby Lotion',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],

            [
                'info' => [
                    'name' => 'Moisturizing Bedtime Lotion',
                    'category' => 59,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Moisturizing Bedtime Lotion',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],

            [
                'info' => [
                    'name' => 'Baby Body Oil Moisturizer',
                    'category' => 59,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 30,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Body Oil Moisturizer',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],

            [
                'info' => [
                    'name' => 'Kids Face and Body Gel Cream',
                    'category' => 59,
                    'brand' => 3,
                    'unit_id' => 6,
                    'buying_price' => 5,
                    'selling_price' => 10,
                    'variation_price' => 10,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'seo' => [
                    'title' => 'Kids Face and Body Gel Cream',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],

            [
                'info' => [
                    'name' => 'Bedtime Bath & Body Lotion',
                    'category' => 59,
                    'brand' => 4,
                    'unit_id' => 6,
                    'buying_price' => 13,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",

                ],
                'seo' => [
                    'title' => 'Bedtime Bath & Body Lotion',
                    'meta_keyword' => ['Baby', 'Skincare'],
                    'description' => "<p>All our recipes are made with fruits and veggies that meet Gerber’s high-quality standards. This baby food stage 2 recipe includes a lot of love, care, 3/4 banana, 1-1/2 blackberries and eight blueberries in each tub for a tantalizing combination.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Baby', 'Skincare'],
                'image_path' => 'baby_care/baby_skincare',
            ],

            // Baby Oral Care
            [
                'info' => [
                    'name' => 'Newborn Baby Toothbrush',
                    'category' => 60,
                    'brand' => null,
                    'unit_id' => 6,
                    'buying_price' => 15,
                    'selling_price' => 25,
                    'variation_price' => 25,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'seo' => [
                    'title' => 'Newborn Baby Toothbrush',
                    'meta_keyword' => ['Baby', 'Oral Care'],
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Baby', 'Oral Care'],
                'image_path' => 'baby_care/baby_oral_care',
            ],

            [
                'info' => [
                    'name' => 'Oral Care Kit with Xylitol Wipes',
                    'category' => 60,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 30,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'seo' => [
                    'title' => 'Oral Care Kit with Xylitol Wipes',
                    'meta_keyword' => ['Baby', 'Oral Care'],
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Baby', 'Oral Care'],
                'image_path' => 'baby_care/baby_oral_care',
            ],

            [
                'info' => [
                    'name' => 'Disposable Infant Toothbrush',
                    'category' => 60,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 26,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'seo' => [
                    'title' => 'Disposable Infant Toothbrush',
                    'meta_keyword' => ['Baby', 'Oral Care'],
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Baby', 'Oral Care'],
                'image_path' => 'baby_care/baby_oral_care',
            ],

            [
                'info' => [
                    'name' => 'Baby Oral Care Kit 5pc',
                    'category' => 60,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Oral Care Kit 5pc',
                    'meta_keyword' => ['Baby', 'Oral Care'],
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Baby', 'Oral Care'],
                'image_path' => 'baby_care/baby_oral_care',
            ],

            [
                'info' => [
                    'name' => 'Baby Oral Cleaning Stick',
                    'category' => 60,
                    'brand' => 2,
                    'unit_id' => 1,
                    'buying_price' => 24,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'seo' => [
                    'title' => 'Baby Oral Cleaning Stick',
                    'meta_keyword' => ['Baby', 'Oral Care'],
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Baby', 'Oral Care'],
                'image_path' => 'baby_care/baby_oral_care',
            ],
            [
                'info' => [
                    'name' => 'Round Head Baby Soft Toothbrush',
                    'category' => 60,
                    'brand' => 2,
                    'unit_id' => 1,
                    'buying_price' => 51,
                    'selling_price' => 59,
                    'variation_price' => 59,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'seo' => [
                    'title' => 'Round Head Baby Soft Toothbrush',
                    'meta_keyword' => ['Baby', 'Oral Care'],
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Baby', 'Oral Care'],
                'image_path' => 'baby_care/baby_oral_care',
            ],
            [
                'info' => [
                    'name' => 'Teeth Cleansing Liquid 50ml',
                    'category' => 60,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 34,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'seo' => [
                    'title' => 'Teeth Cleansing Liquid 50ml',
                    'meta_keyword' => ['Baby', 'Oral Care'],
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Baby', 'Oral Care'],
                'image_path' => 'baby_care/baby_oral_care',
            ],
            [
                'info' => [
                    'name' => 'Solid Color Children Toothbrush',
                    'category' => 60,
                    'brand' => 2,
                    'unit_id' => 1,
                    'buying_price' => 5,
                    'selling_price' => 10,
                    'variation_price' => 10,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'seo' => [
                    'title' => 'Solid Color Children Toothbrush',
                    'meta_keyword' => ['Baby', 'Oral Care'],
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Baby', 'Oral Care'],
                'image_path' => 'baby_care/baby_oral_care',
            ],
            [
                'info' => [
                    'name' => 'Oral Care Toothbrush for Baby',
                    'category' => 60,
                    'brand' => 2,
                    'unit_id' => 1,
                    'buying_price' => 13,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",

                ],
                'seo' => [
                    'title' => 'Oral Care Toothbrush for Baby',
                    'meta_keyword' => ['Baby', 'Oral Care'],
                    'description' => "<p>Celebrate the coming or arrival of a new blessing with our new Baby oral care kit of Baby Buddy by Brilliant's Oral Care Program. Each kit includes a 30 ct of our Tooth Tissues dental wipes with Xylitol, as well as three soft silicone toothbrushes: finger toothbrush, wipe-n-brush, and baby's 1st teether brush.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Baby', 'Oral Care'],
                'image_path' => 'baby_care/baby_oral_care',
            ],

            // Newborn Essentials
            [
                'info' => [
                    'name' => 'Stain Remover Essentials',
                    'category' => 61,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 5,
                    'selling_price' => 10,
                    'variation_price' => 10,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 2,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'seo' => [
                    'title' => 'Stain Remover Essentials',
                    'meta_keyword' => ['Newborn Essentials'],
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Newborn Essentials'],
                'image_path' => 'baby_care/newborn_essentials',
            ],
            [
                'info' => [
                    'name' => 'New Baby Essentials Kit, 6 Piece',
                    'category' => 61,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 13,
                    'selling_price' => 19,
                    'variation_price' => 19,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",

                ],
                'seo' => [
                    'title' => 'New Baby Essentials Kit, 6 Piece',
                    'meta_keyword' => ['Newborn Essentials'],
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Newborn Essentials'],
                'image_path' => 'baby_care/newborn_essentials',
            ],

            [
                'info' => [
                    'name' => 'Bag To Go Kit Baby Essentials',
                    'category' => 61,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 30,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'seo' => [
                    'title' => 'Bag To Go Kit Baby Essentials',
                    'meta_keyword' => ['Newborn Essentials'],
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['Newborn Essentials'],
                'image_path' => 'baby_care/newborn_essentials',
            ],

            [
                'info' => [
                    'name' => 'Simply Baby Necessities Basket',
                    'category' => 61,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 26,
                    'selling_price' => 33,
                    'variation_price' => 33,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'seo' => [
                    'title' => 'Simply Baby Necessities Basket',
                    'meta_keyword' => ['Newborn Essentials'],
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['Newborn Essentials'],
                'image_path' => 'baby_care/newborn_essentials',
            ],

            [
                'info' => [
                    'name' => 'Silicone Material Newborn Essentials',
                    'category' => 61,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 35,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'seo' => [
                    'title' => 'Silicone Material Newborn Essentials',
                    'meta_keyword' => ['Newborn Essentials'],
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'taxes' => [4],
                'tags' => ['Newborn Essentials'],
                'image_path' => 'baby_care/newborn_essentials',
            ],

            [
                'info' => [
                    'name' => 'Sick Baby & Newborn Essentials',
                    'category' => 61,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 24,
                    'selling_price' => 35,
                    'variation_price' => 35,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 5,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'seo' => [
                    'title' => 'Sick Baby & Newborn Essentials',
                    'meta_keyword' => ['Newborn Essentials'],
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'taxes' => [3],
                'tags' => ['Newborn Essentials'],
                'image_path' => 'baby_care/newborn_essentials',
            ],
            [
                'info' => [
                    'name' => 'Grooming Kit for Newborns',
                    'category' => 61,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 51,
                    'selling_price' => 59,
                    'variation_price' => 59,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 3,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'seo' => [
                    'title' => 'Grooming Kit for Newborns',
                    'meta_keyword' => ['Newborn Essentials'],
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Newborn Essentials'],
                'image_path' => 'baby_care/newborn_essentials',
            ],
            [
                'info' => [
                    'name' => 'New Baby Boy Essentials',
                    'category' => 61,
                    'brand' => 2,
                    'unit_id' => 6,
                    'buying_price' => 34,
                    'selling_price' => 45,
                    'variation_price' => 45,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 4,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'seo' => [
                    'title' => 'New Baby Boy Essentials',
                    'meta_keyword' => ['Newborn Essentials'],
                    'description' => "<p>This baby essentials gift set includes pediatrician recommended laundry detergent, stain remover, all purpose cleaner, scent booster, and coupons to offer additional savings. Dreft Stage 1 Newborn liquid detergent is specially made for your newborn baby's skin, which is why it's the #1 Pediatrician Recommended Baby Detergent and has been trusted by moms for over 80 years.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['Newborn Essentials'],
                'image_path' => 'baby_care/newborn_essentials',
            ],

            // Home & Kitchen -> Kitchen Accessories
            [
                'info' => [
                    'name' => '3-Piece Kitchen Utensil Set',
                    'category' => 63,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 200,
                    'selling_price' => 310,
                    'variation_price' => 310,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'seo' => [
                    'title' => '3-Piece Kitchen Utensil Set',
                    'meta_keyword' => ['Kitchen', 'Accessories'],
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Kitchen Utensil', 'Utensil Set'],
                'image_path' => 'home_&_kitchen/kitchen_accessories',
            ],
            [
                'info' => [
                    'name' => '3 Gal. Round SwingTop',
                    'category' => 63,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 200,
                    'selling_price' => 320,
                    'variation_price' => 320,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'seo' => [
                    'title' => '3 Gal. Round SwingTop',
                    'meta_keyword' => ['Kitchen', 'Accessories'],
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'taxes' => [3],
                'tags' => ['3 Gal. Round', 'SwingTop'],
                'image_path' => 'home_&_kitchen/kitchen_accessories',
            ],
            [
                'info' => [
                    'name' => '8-Piece Nylon Kitchen Set',
                    'category' => 63,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 200,
                    'selling_price' => 330,
                    'variation_price' => 330,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'seo' => [
                    'title' => '8-Piece Nylon Kitchen Set',
                    'meta_keyword' => ['Kitchen', 'Accessories'],
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'taxes' => [4],
                'tags' => ['8-Piece Nylon', 'Kitchen Set'],
                'image_path' => 'home_&_kitchen/kitchen_accessories',
            ],
            [
                'info' => [
                    'name' => '12 Piece Kitchen Set Plastic',
                    'category' => 63,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 200,
                    'selling_price' => 330,
                    'variation_price' => 330,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'seo' => [
                    'title' => '12 Piece Kitchen Set Plastic',
                    'meta_keyword' => ['Kitchen', 'Accessories'],
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['12 Piece Kitchen', 'Set Plastic'],
                'image_path' => 'home_&_kitchen/kitchen_accessories',
            ],
            [
                'info' => [
                    'name' => '28-piece Kitchen Utensil Set',
                    'category' => 63,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 210,
                    'selling_price' => 340,
                    'variation_price' => 340,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'seo' => [
                    'title' => '28-piece Kitchen Utensil Set',
                    'meta_keyword' => ['Kitchen', 'Accessories'],
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'taxes' => [3, 4],
                'tags' => ['28-piece Kitchen ', 'Utensil Set'],
                'image_path' => 'home_&_kitchen/kitchen_accessories',
            ],
            [
                'info' => [
                    'name' => '14-piece Kitchen Tool',
                    'category' => 63,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 210,
                    'selling_price' => 350,
                    'variation_price' => 350,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'seo' => [
                    'title' => '14-piece Kitchen Tool',
                    'meta_keyword' => ['Kitchen', 'Accessories'],
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'taxes' => [2, 4],
                'tags' => ['14-piece', 'Kitchen Tool'],
                'image_path' => 'home_&_kitchen/kitchen_accessories',
            ],
            [
                'info' => [
                    'name' => '29 Pcs Silicone Cooking Set',
                    'category' => 63,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 210,
                    'selling_price' => 360,
                    'variation_price' => 360,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'seo' => [
                    'title' => '29 Pcs Silicone Cooking Set',
                    'meta_keyword' => ['Kitchen', 'Accessories'],
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'taxes' => [1, 2, 3],
                'tags' => ['29 Pcs Silicone', 'Cooking Set'],
                'image_path' => 'home_&_kitchen/kitchen_accessories',
            ],
            [
                'info' => [
                    'name' => 'Kitchen Utensil Spatula Set',
                    'category' => 63,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 210,
                    'selling_price' => 380,
                    'variation_price' => 380,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'seo' => [
                    'title' => 'Kitchen Utensil Spatula Set',
                    'meta_keyword' => ['Kitchen', 'Accessories'],
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'taxes' => [2, 3, 4],
                'tags' => ['Kitchen Utensil ', 'Spatula Set'],
                'image_path' => 'home_&_kitchen/kitchen_accessories',
            ],
            [
                'info' => [
                    'name' => 'Kitchen Gadgets Tools Set',
                    'category' => 63,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 210,
                    'selling_price' => 390,
                    'variation_price' => 390,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'seo' => [
                    'title' => 'Kitchen Gadgets Tools Set',
                    'meta_keyword' => ['Kitchen', 'Accessories'],
                    'description' => "<p>These tools are handy for everyday cooking and cover most of your basic cooking tool needs. The Mainstays utensil set includes a slotted spatula for flipping eggs or serving cookies off a baking sheet, a basting spoon for serving or stirring soups and sauces, and a slotted basting spoon that strains as it serves.</p>",
                ],
                'taxes' => [1, 2, 3, 4],
                'tags' => ['Kitchen Gadgets', 'Tools Set'],
                'image_path' => 'home_&_kitchen/kitchen_accessories',
            ],

            // Home & Kitchen -> Kitchen Appliances
            [
                'info' => [
                    'name' => '4-Quart Classic Slow Cooker',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 210,
                    'selling_price' => 400,
                    'variation_price' => 400,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => '4-Quart Classic Slow Cooker',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [1, 2, 3, 4],
                'tags' => ['4-Quart Classic', 'Slow Cooker'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],
            [
                'info' => [
                    'name' => '2-Slice Toaster Black',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 410,
                    'variation_price' => 410,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => '2-Slice Toaster Black',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [1, 2, 3],
                'tags' => ['2-Slice Toaster', 'Black'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],
            [
                'info' => [
                    'name' => 'Crisp N Bake Air Fry Toaster',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 420,
                    'variation_price' => 420,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => 'Crisp N Bake Air Fry Toaster',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [1, 2],
                'tags' => ['Crisp N Bake Air', 'Fry Toaster'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],
            [
                'info' => [
                    'name' => 'Ninja 4QT Air Fryer, Black',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 430,
                    'variation_price' => 430,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => 'Ninja 4QT Air Fryer, Black',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [1, 2],
                'tags' => ['Ninja 4QT Air Fryer', 'Black'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],
            [
                'info' => [
                    'name' => '18 Piece Non-stick Cookware',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 440,
                    'variation_price' => 440,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 30,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => '18 Piece Non-stick Cookware',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [1],
                'tags' => ['18 Piece Non-stick', 'Cookware'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],
            [
                'info' => [
                    'name' => 'Mainstays 2 QT Slow Cooker',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 450,
                    'variation_price' => 450,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::YES,
                    'discount' => 40,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => 'Mainstays 2 QT Slow Cooker',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [1, 2],
                'tags' => ['Mainstays 2 QT', 'Slow Cooker'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],
            [
                'info' => [
                    'name' => 'Compact Personal Blender',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 460,
                    'variation_price' => 460,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 10,
                    'offer_start_date' => now(),
                    'offer_end_date' => Carbon::now()->addDays(365),
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => 'Compact Personal Blender',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [1, 3],
                'tags' => ['Compact Personal', 'Blender'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],
            [
                'info' => [
                    'name' => 'Qt Air Fryer with TurboCrisp',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 460,
                    'variation_price' => 460,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => 'Qt Air Fryer with TurboCrisp',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [2, 3],
                'tags' => ['Qt Air Fryer', 'TurboCrisp'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],
            [
                'info' => [
                    'name' => 'Beautiful 5.3 Qt Stand Mixer',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 270,
                    'selling_price' => 470,
                    'variation_price' => 470,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => 'Beautiful 5.3 Qt Stand Mixer',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [2, 3],
                'tags' => ['Beautiful 5.3 Qt', 'Stand Mixer'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],
            [
                'info' => [
                    'name' => 'Beautiful 6 Qt Slow Cooker',
                    'category' => 64,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 290,
                    'selling_price' => 480,
                    'variation_price' => 480,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'seo' => [
                    'title' => 'Beautiful 6 Qt Slow Cooker',
                    'meta_keyword' => ['Kitchen', 'Appliances'],
                    'description' => "The 4-quart capacity feeds 4+ people and is perfect for making family meals. Use the manual warm setting to keep food warm while you are serving, or for heating up leftovers. The removable stoneware is oven-safe up to 400 degrees F, so you can put it in the oven to add a delicious finishing crisp to your favorite meals.",
                ],
                'taxes' => [2, 3],
                'tags' => ['Beautiful 6 Qt', 'Slow Cooker'],
                'image_path' => 'home_&_kitchen/kitchen_appliances',
            ],

            // Home & Kitchen -> Tools & Hardware
            [
                'info' => [
                    'name' => '118 Piece Tool Set for Home',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 110,
                    'selling_price' => 240,
                    'variation_price' => 240,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => '118 Piece Tool Set for Home',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [4],
                'tags' => ['118-Piece Tool', 'Set for Home'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],
            [
                'info' => [
                    'name' => 'DT9706P 39-Piece Tool Set',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 400,
                    'selling_price' => 450,
                    'variation_price' => 450,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => 'DT9706P 39-Piece Tool Set',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [4],
                'tags' => ['DT9706P 39-Piece', 'Tool Set'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],
            [
                'info' => [
                    'name' => '89-Piece Pink Household Tool',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 410,
                    'selling_price' => 460,
                    'variation_price' => 460,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => '89-Piece Pink Household Tool',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [2],
                'tags' => ['Pink Household Tool ', '89-Piece'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],
            [
                'info' => [
                    'name' => 'Thors Hammer 30-Piece Tool',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 420,
                    'selling_price' => 470,
                    'variation_price' => 470,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => 'Thors Hammer 30-Piece Tool',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [3],
                'tags' => ['30-Piece Tool ', ' Thors Hammer'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],
            [
                'info' => [
                    'name' => '108-Piece Hand Tool Set',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 430,
                    'selling_price' => 480,
                    'variation_price' => 480,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => '108-Piece Hand Tool Set',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [3],
                'tags' => ['108 Piece ', 'Hand Tool'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],
            [
                'info' => [
                    'name' => '148-Piece Hand Tool Set',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 430,
                    'selling_price' => 490,
                    'variation_price' => 490,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => '148-Piece Hand Tool Set',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [4],
                'tags' => ['148 Piece', 'Hand Tool'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],
            [
                'info' => [
                    'name' => '65-Piece DIY Tool Kit',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 430,
                    'selling_price' => 500,
                    'variation_price' => 500,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => '65-Piece DIY Tool Kit',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [4],
                'tags' => ['65-Piece DIY ', 'Tool Kit'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],
            [
                'info' => [
                    'name' => '207 Piece Home Repairing Tool',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 470,
                    'selling_price' => 510,
                    'variation_price' => 510,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => '207 Piece Home Repairing Tool',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [4],
                'tags' => ['207 Piece Home ', 'Repairing Tool'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],
            [
                'info' => [
                    'name' => 'Repair Kit Combination Tool Set',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 470,
                    'selling_price' => 520,
                    'variation_price' => 520,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => 'Repair Kit Combination Tool Set',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [1, 2, 4],
                'tags' => ['Repair Kit Combination', 'Tool Set'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],
            [
                'info' => [
                    'name' => 'General Tool Kits for Household',
                    'category' => 65,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 470,
                    'selling_price' => 520,
                    'variation_price' => 520,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'seo' => [
                    'title' => 'General Tool Kits for Household',
                    'meta_keyword' => ['Tools', 'Hardware'],
                    'description' => "<p>The Hyper Tough 118-Piece Home Repair Tool Set is the perfect combination of tools for your home repair and DIY project needs. This all-in-one tool kit includes essential tools such as: 8 oz. rip claw hammer, 6-Inch adjustable wrench, 3 plier types, 9-Inch torpedo level, 3/8-inch ratchet with sockets, hex keys in both SAE, metric, and much more!</p>",
                ],
                'taxes' => [1, 2, 4],
                'tags' => ['General Tool', 'Kits for Household'],
                'image_path' => 'home_&_kitchen/tools_&_hardware',
            ],

            // Home & Kitchen -> Lights & Electrical
            [
                'info' => [
                    'name' => 'LED Light Bulb, 7.5 Watts',
                    'category' => 66,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 200,
                    'selling_price' => 300,
                    'variation_price' => 300,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'seo' => [
                    'title' => 'LED Light Bulb, 7.5 Watts',
                    'meta_keyword' => ['Lights', 'Electrical'],
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'taxes' => [2, 3],
                'tags' => ['LED Light Bulb', '7.5 Watts'],
                'image_path' => 'home_&_kitchen/lights_&_electrical',
            ],
            [
                'info' => [
                    'name' => 'LED Light Bulb, 4 Watts',
                    'category' => 66,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 350,
                    'variation_price' => 350,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'seo' => [
                    'title' => 'LED Light Bulb, 4 Watts',
                    'meta_keyword' => ['Lights', 'Electrical'],
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'taxes' => [2],
                'tags' => ['LED Light Bulb', '4 Watts'],
                'image_path' => 'home_&_kitchen/lights_&_electrical',
            ],
            [
                'info' => [
                    'name' => 'LED 6.5ft Multi-Color Strip',
                    'category' => 66,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 250,
                    'selling_price' => 350,
                    'variation_price' => 350,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'seo' => [
                    'title' => 'LED 6.5ft Multi-Color Strip',
                    'meta_keyword' => ['Lights', 'Electrical'],
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'taxes' => [2],
                'tags' => ['LED 6.5ft Multi', 'Color Strip'],
                'image_path' => 'home_&_kitchen/lights_&_electrical',
            ],
            [
                'info' => [
                    'name' => 'Wi-Fi Connected LED 60-Watt',
                    'category' => 66,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 200,
                    'selling_price' => 250,
                    'variation_price' => 250,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'seo' => [
                    'title' => 'Wi-Fi Connected LED 60-Watt',
                    'meta_keyword' => ['Lights', 'Electrical'],
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'taxes' => [2],
                'tags' => ['Wi-Fi Connected LED ', '60-Watt'],
                'image_path' => 'home_&_kitchen/lights_&_electrical',
            ],
            [
                'info' => [
                    'name' => 'LED Vintage Light Bulb',
                    'category' => 66,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 100,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'seo' => [
                    'title' => 'LED Vintage Light Bulb',
                    'meta_keyword' => ['Lights', 'Electrical'],
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'taxes' => [1],
                'tags' => ['LED Vintage ', 'Light Bulb'],
                'image_path' => 'home_&_kitchen/lights_&_electrical',
            ],
            [
                'info' => [
                    'name' => '50ft Vinyl Electrical Tape',
                    'category' => 66,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 100,
                    'selling_price' => 200,
                    'variation_price' => 200,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'seo' => [
                    'title' => '50ft Vinyl Electrical Tape',
                    'meta_keyword' => ['Lights', 'Electrical'],
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'taxes' => [3],
                'tags' => ['50ft Vinyl', 'Electrical Tape'],
                'image_path' => 'home_&_kitchen/lights_&_electrical',
            ],
            [
                'info' => [
                    'name' => '6-Outlet Surge Protector Tap',
                    'category' => 66,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 105,
                    'selling_price' => 199,
                    'variation_price' => 199,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'seo' => [
                    'title' => '6-Outlet Surge Protector Tap',
                    'meta_keyword' => ['Lights', 'Electrical'],
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'taxes' => [4],
                'tags' => ['6-Outlet Surge', 'Protector Tap'],
                'image_path' => 'home_&_kitchen/lights_&_electrical',
            ],
            [
                'info' => [
                    'name' => '4ft Cord Small Wall Charger',
                    'category' => 66,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 110,
                    'selling_price' => 210,
                    'variation_price' => 210,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'seo' => [
                    'title' => '4ft Cord Small Wall Charger',
                    'meta_keyword' => ['Lights', 'Electrical'],
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'taxes' => [1],
                'tags' => ['4ft Cord Small', 'Wall Charger'],
                'image_path' => 'home_&_kitchen/lights_&_electrical',
            ],
            [
                'info' => [
                    'name' => '25 Ft. Retractable Cord Reel',
                    'category' => 66,
                    'brand' => null,
                    'unit_id' => 1,
                    'buying_price' => 110,
                    'selling_price' => 230,
                    'variation_price' => 230,
                    'purchasable' => Ask::YES,
                    'refundable' => Ask::NO,
                    'flash_sale' => Ask::NO,
                    'discount' => 0,
                    'offer_start_date' => null,
                    'offer_end_date' => null,
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'seo' => [
                    'title' => '25 Ft. Retractable Cord Reel',
                    'meta_keyword' => ['Lights', 'Electrical'],
                    'description' => "<p>Use them to create a fun atmosphere for parties, show support for your favorite sports teams, show support for your favorite causes, and for holiday decoration. They are long lasting, energy efficient bulbs that will make your home festive for any occasion.</p>",
                ],
                'taxes' => [4],
                'tags' => ['25 Ft. Retractable', 'Cord Reel'],
                'image_path' => 'home_&_kitchen/lights_&_electrical',
            ],

        ];

        $envService = new EnvEditor();
        if ($envService->getValue('DEMO')) {
            foreach ($groceryProducts as $groceryProduct) {
                $sku = date('is') . rand(100, 999);
                $productObject = Product::create([
                    'name'                       => $groceryProduct['info']['name'],
                    'slug'                       => Str::slug($groceryProduct['info']['name'] . rand(1, 1000)),
                    'sku'                        => $sku,
                    'product_category_id'        => $groceryProduct['info']['category'],
                    'product_brand_id'           => $groceryProduct['info']['brand'],
                    'barcode_id'                 => 1,
                    'unit_id'                    => $groceryProduct['info']['unit_id'],
                    'buying_price'               => $groceryProduct['info']['buying_price'],
                    'selling_price'              => $groceryProduct['info']['selling_price'],
                    'variation_price'            => $groceryProduct['info']['variation_price'],
                    'status'                     => Status::ACTIVE,
                    'order'                      => 1,
                    'can_purchasable'            => $groceryProduct['info']['purchasable'],
                    'show_stock_out'             => Activity::DISABLE,
                    'maximum_purchase_quantity'  => 100,
                    'low_stock_quantity_warning' => 2,
                    'weight'                     => null,
                    'refundable'                 => $groceryProduct['info']['refundable'],
                    'add_to_flash_sale'          => $groceryProduct['info']['flash_sale'],
                    'discount'                   => $groceryProduct['info']['discount'],
                    'offer_start_date'           => $groceryProduct['info']['offer_start_date'],
                    'offer_end_date'             => $groceryProduct['info']['offer_end_date'],
                    'sell_by_fraction'           => $groceryProduct['info']['sell_by_fraction'] ?? Ask::NO,
                    'description'                => $groceryProduct['info']['description'],
                ]);

                if (isset($groceryProduct['taxes']) && count($groceryProduct['taxes'])) {
                    foreach ($groceryProduct['taxes'] as $tax) {
                        ProductTax::create([
                            'product_id' => $productObject->id,
                            'tax_id'     => $tax,
                        ]);
                    }
                }

                if (isset($groceryProduct['tags']) && count($groceryProduct['tags'])) {
                    foreach ($groceryProduct['tags'] as $tag) {
                        ProductTag::create([
                            'product_id' => $productObject->id,
                            'name'       => $tag,
                        ]);
                    }
                }

                $generator     = new BarcodeGeneratorJPG();
                $barcode_value = str_pad($sku, 12, '0', STR_PAD_LEFT);
                $barcode       = $generator->getBarcode($barcode_value, $generator::TYPE_EAN_13);
                $tempFilePath  = storage_path('app/public/barcode.jpg');
                file_put_contents($tempFilePath, $barcode);
                $productObject->addMedia($tempFilePath)->toMediaCollection('product-barcode');

                if (isset($groceryProduct['seo'])) {
                    $productSeo = ProductSeo::create([
                        'product_id'   => $productObject->id,
                        'title'        => $groceryProduct['seo']['title'],
                        'meta_keyword' => json_encode($groceryProduct['seo']['meta_keyword']),
                        'description'  => $groceryProduct['seo']['description'],
                    ]);

                    if (file_exists(public_path('/images/seeder/product/' . '/' . $groceryProduct['image_path'] . '/' . strtolower(str_replace(' ', '_', $groceryProduct['info']['name'])) . '.png'))) {
                        $productSeo->addMedia(public_path('/images/seeder/product/' . '/' . $groceryProduct['image_path'] . '/' . strtolower(str_replace(' ', '_', $groceryProduct['info']['name'])) . '.png'))->preservingOriginal()->toMediaCollection('product-seo');
                    }
                }

                if (file_exists(public_path('/images/seeder/product/' . '/' . $groceryProduct['image_path'] . '/' . strtolower(str_replace(' ', '_', $groceryProduct['info']['name'])) . '.png'))) {
                    $productObject->addMedia(public_path('/images/seeder/product/' . '/' . $groceryProduct['image_path'] . '/' . strtolower(str_replace(' ', '_', $groceryProduct['info']['name'])) . '.png'))->preservingOriginal()->toMediaCollection('product');
                }
            }
        }
    }
}
